(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    150092,       4260]*)
(*NotebookOutlinePosition[    151054,       4289]*)
(*  CellTagsIndexPosition[    151010,       4285]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Aplicaciones de las integrales simples", "Title"],

Cell["\<\

Universidad de Granada
Departamento de An\[AAcute]lisis Matem\[AAcute]tico
Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez
\
\>", "Text",
  PageBreakBelow->False,
  TextAlignment->Left,
  LineSpacing->{0.4, 0},
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell["Introducci\[OAcute]n", "Section"],

Cell[TextData[{
  "Este cuaderno debe ejecutarse con las versiones 4 o 5 de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".\nCon una integral puedes calcular magnitudes tan diversas como \
\[AAcute]reas, vol\[UAcute]menes, longitudes de curvas, el trabajo realizado \
por una fuerza, el punto de equilibrio y la masa de un s\[OAcute]lido, \
momentos de inercia, el campo electrost\[AAcute]tico producido por una \
distribuci\[OAcute]n de cargas, el flujo de una fluido a trav\[EAcute]s de \
una superficie y muchas m\[AAcute]s."
}], "Text"],

Cell["\<\
Lo que debes aprender en este cuaderno.
Calcular \[AAcute]reas de recintos en el plano limitados por varias curvas.
Calcular \[AAcute]reas de curvas cerradas dadas por sus ecuaciones param\
\[EAcute]tricas.
Calcular longitudes de curvas.
Calcular vol\[UAcute]menes de cuerpos de revoluci\[OAcute]n por el \
m\[EAcute]todo de los discos, de las arandelas y de los tubos.
Calcular \[AAcute]reas de superficies de revoluci\[OAcute]n.\
\>", "Text"],

Cell[TextData[
"Para trabajar en este cuaderno debes evaluar primero ( Kernel \[Rule] \
Evaluation\[RightArrow] Evaluate Initialization )  las celdas de inicializaci\
\[OAcute]n que siguen.  "], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inicializaci\[OAcute]n", "Section"],

Cell[BoxData[
    \(<< Graphics`\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(Off[General::"\<spell1\>"]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(tipo1[{func1_, func2_}, {var_, xmin_, xmax_}, opts___] := 
      Show[{FilledPlot[{func1, func2}, {var, xmin, xmax}, opts, 
            DisplayFunction \[Rule] Identity], 
          Graphics[{Line[{{xmin, func1 /. var \[Rule] xmin}, {xmin, 
                    func2 /. var \[Rule] xmin}}], 
              Line[{{xmax, func1 /. var \[Rule] xmax}, {xmax, 
                    func2 /. var \[Rule] xmax}}]}]}, 
        DisplayFunction \[Rule] $DisplayFunction]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(tipo1sup[{func1_, func2_}, {var_, xmin_, xmax_, sub_}, 
          opts___] := \[IndentingNewLine]\t
        Module[{rects, n, graf, inc, cotas, 
            area = 0}, \[IndentingNewLine]inc = 
            N[\((xmax\  - \ xmin)\)/sub]; \[IndentingNewLine]rects\  = \ 
            Table[\n\t\t\t\t\(\((area = 
                      area + \((Max[#2, #4] - Min[#1, #3])\) inc; {RGBColor[
                        0, 1, 1], 
                      Rectangle[{n, Min[#1, #3]}, {n + inc, Max[#2, #4]}], 
                      GrayLevel[0], 
                      Line[{{n, Max[#2, #4]}, {n + inc, 
                            Max[#2, #4]}, {n + inc, Min[#1, #3]}, {n, 
                            Min[#1, #3]}, {n, Max[#2, #4]}}], 
                      RGBColor[1, 0, 0], 
                      Point[{Last[
                            Last[Sort[
                                Transpose[{func1 /. 
                                      var -> Table[
                                        n + j, {j, 0, inc, inc/10}], 
                                    Table[n + j, {j, 0, inc, inc/10}]}]]]], 
                          Max[#2, #4]}], 
                      Point[{Last[
                            Last[Sort[
                                Transpose[{func2 /. 
                                      var -> Table[
                                        n + j, {j, 0, inc, inc/10}], 
                                    Table[n + j, {j, 0, inc, inc/10}]}]]]], 
                          Min[#1, #3]}]})\) &\)[
                Min[func1 /. var \[Rule] Table[n + j, {j, 0, inc, inc/10}]], 
                Max[func2 /. var \[Rule] Table[n + j, {j, 0, inc, inc/10}]], 
                Min[func2 /. var \[Rule] Table[n + j, {j, 0, inc, inc/10}]], 
                Max[func1 /. 
                    var \[Rule] 
                      Table[n + j, {j, 0, inc, 
                          inc/10}]]], \[IndentingNewLine]{n, xmin, 
                xmax - \ inc, 
                inc}]; \[IndentingNewLine]\t\tcotas = {Line[{{xmin, 
                    func1 /. var \[Rule] xmin}, {xmin, 
                    func2 /. var \[Rule] xmin}}], 
              Line[{{xmax, func1 /. var \[Rule] xmax}, {xmax, 
                    func2 /. var \[Rule] xmax}}]}; \[IndentingNewLine]graf = 
            Plot[{func1, func2}, \ {var, xmin, xmax}, 
              DisplayFunction \[Rule] Identity]; \ \[IndentingNewLine]\t
          Show[{Graphics[{PointSize[0.02], rects}], graf, Graphics[cotas]}, 
            DisplayFunction \[Rule] $DisplayFunction, 
            opts, \[IndentingNewLine]PlotLabel\  \[Rule] 
              StyleForm[
                TraditionalForm["\<Area \[TildeEqual]\>" <> ToString[area]], 
                FontSlant \[Rule] "\<Italic\>", 
                FontSize \[Rule] 12]]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(tipo1inf[{func1_, func2_}, {var_, xmin_, xmax_, sub_}, 
          opts___] := \[IndentingNewLine]\t
        Module[{rects, n, graf, inc, cotas, 
            area = 0}, \[IndentingNewLine]inc = 
            N[\((xmax\  - \ xmin)\)/sub]; \[IndentingNewLine]rects\  = \ 
            Table[\n\t\t\t\t\(\((area = 
                      area + \((Max[#1, #3] - Min[#2, #4])\) inc; {RGBColor[
                        1, 0, 0], 
                      Point[{Last[
                            Last[Sort[
                                Transpose[{func1 /. 
                                      var -> Table[
                                        n + j, {j, 0, inc, inc/10}], 
                                    Table[n + j, {j, 0, inc, inc/10}]}]]]], 
                          Min[#2, #4]}], 
                      Point[{Last[
                            Last[Sort[
                                Transpose[{func2 /. 
                                      var -> Table[
                                        n + j, {j, inc, inc, inc/10}], 
                                    Table[n + j, {j, inc, inc, inc/10}]}]]]], 
                          Max[#1, #3]}], RGBColor[0, 1, 1], 
                      Rectangle[{n, Min[#2, #4]}, {n + inc, Max[#1, #3]}], 
                      GrayLevel[0], 
                      Line[{{n, Min[#2, #4]}, {n + inc, 
                            Min[#2, #4]}, {n + inc, Max[#1, #3]}, {n, 
                            Max[#1, #3]}, {n, Min[#2, #4]}}]})\) &\)[
                Min[func1 /. var \[Rule] Table[n + j, {j, 0, inc, inc/10}]], 
                Max[func2 /. var \[Rule] Table[n + j, {j, 0, inc, inc/10}]], 
                Min[func2 /. var \[Rule] Table[n + j, {j, 0, inc, inc/10}]], 
                Max[func1 /. 
                    var \[Rule] 
                      Table[n + j, {j, 0, inc, 
                          inc/10}]]], \[IndentingNewLine]{n, xmin, 
                xmax - \ inc, 
                inc}]; \[IndentingNewLine]\t\tcotas = {Line[{{xmin, 
                    func1 /. var \[Rule] xmin}, {xmin, 
                    func2 /. var \[Rule] xmin}}], 
              Line[{{xmax, func1 /. var \[Rule] xmax}, {xmax, 
                    func2 /. var \[Rule] xmax}}]}; \[IndentingNewLine]graf = 
            FilledPlot[{func1, func2}, \ {var, xmin, xmax}, 
              Fills \[Rule] {RGBColor[1, 1, 0]}, 
              DisplayFunction \[Rule] Identity]; \ \[IndentingNewLine]\t
          Show[{graf, Graphics[cotas]}, 
            DisplayFunction \[Rule] $DisplayFunction, opts, 
            Epilog \[Rule] {PointSize[0.02], 
                rects}, \[IndentingNewLine]PlotLabel\  \[Rule] 
              StyleForm[
                TraditionalForm["\<Area \[TildeEqual]\>" <> ToString[area]], 
                FontSlant \[Rule] "\<Italic\>", 
                FontSize \[Rule] 12]]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(tipo2[{func1_, func2_}, {var_, ymin_, ymax_}, opts___] := 
        Module[{graf}, 
          graf = ParametricPlot[{{func1, var}, {func2, var}}, {var, ymin, 
                ymax}, PlotStyle -> {Thickness[ .013], Thickness[ .013]}, 
              DisplayFunction \[Rule] 
                Identity]; \[IndentingNewLine]Show[{graf, 
              Graphics[{{Hue[ymin +  .16], 
                    Polygon[
                      Join[graf[\([1, 1, 2, 1, 1]\)], 
                        Reverse[
                          graf[\([1, 2, 2, 1, 1]\)]]]]}, {Thickness[ .0074], 
                    Line[{{func1 /. var \[Rule] ymin, 
                          ymin}, {func2 /. var \[Rule] ymin, 
                          ymin}}]}, {Thickness[ .0074], 
                    Line[{{func1 /. var \[Rule] ymax, 
                          ymax}, {func2 /. var \[Rule] ymax, ymax}}]}}]}, 
            opts, DisplayFunction \[Rule] $DisplayFunction]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(tipo2sup[{func1_, func2_}, {var_, ymin_, ymax_, sub_}, opts___] := 
        Module[{rects, n, graf, inc, cotas, 
            area = 0}, \[IndentingNewLine]inc = 
            N[\((ymax\  - \ ymin)\)/sub]; \[IndentingNewLine]rects\  = \ 
            Table[\n\t\t\t\t\(\((area = 
                      area + \((Max[#2, #4] - Min[#1, #3])\) inc; {RGBColor[
                        0, 1, 1], 
                      Rectangle[{Min[#1, #3], n}, {Max[#2, #4], n + inc}], 
                      GrayLevel[0], 
                      Line[{{Max[#2, #4], n}, {Max[#2, #4], 
                            n + inc}, {Min[#1, #3], n + inc}, {Min[#1, #3], 
                            n}, {Max[#2, #4], n}}], RGBColor[1, 0, 0], 
                      Point[{Max[#2, #4], 
                          Last[Last[
                              Sort[Transpose[{func1 /. 
                                      var -> Table[
                                        n + j, {j, 0, inc, inc/10}], 
                                    Table[n + j, {j, 0, inc, inc/10}]}]]]]}], 
                      Point[{Min[#1, #3], 
                          Last[Last[
                              Sort[Transpose[{func2 /. 
                                      var -> Table[
                                        n + j, {j, 0, inc, inc/10}], 
                                    Table[
                                      n + j, {j, 0, inc, 
                                        inc/10}]}]]]]}]})\) &\)[
                Min[func1 /. var \[Rule] Table[n + j, {j, 0, inc, inc/10}]], 
                Max[func2 /. var \[Rule] Table[n + j, {j, 0, inc, inc/10}]], 
                Min[func2 /. var \[Rule] Table[n + j, {j, 0, inc, inc/10}]], 
                Max[func1 /. 
                    var \[Rule] 
                      Table[n + j, {j, 0, inc, 
                          inc/10}]]], \[IndentingNewLine]{n, ymin, 
                ymax - \ inc, 
                inc}]; \[IndentingNewLine]\t\tcotas = {Line[{{func1 /. 
                      var \[Rule] ymin, ymin}, {func2 /. var \[Rule] ymin, 
                    ymin}}], 
              Line[{{func1 /. var \[Rule] ymax, 
                    ymax}, {func2 /. var \[Rule] ymax, 
                    ymax}}]}; \[IndentingNewLine]graf = 
            ParametricPlot[{{func1, var}, {func2, var}}, \ {var, ymin, ymax}, 
              PlotStyle -> {Thickness[ .0085], Thickness[ .0085]}, 
              DisplayFunction \[Rule] Identity]; \ \[IndentingNewLine]\t
          Show[{Graphics[{PointSize[0.02], rects}], graf, Graphics[cotas]}, 
            DisplayFunction \[Rule] $DisplayFunction, 
            opts, \[IndentingNewLine]PlotLabel\  \[Rule] 
              StyleForm[
                TraditionalForm["\<Area \[TildeEqual]\>" <> ToString[area]], 
                FontSlant \[Rule] "\<Italic\>", 
                FontSize \[Rule] 12]]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(tipo2inf[{func1_, func2_}, {var_, ymin_, ymax_, sub_}, opts___] := 
        Module[{rects, n, graf, inc, cotas, 
            area = 0}, \[IndentingNewLine]inc = 
            N[\((ymax\  - \ ymin)\)/sub]; \[IndentingNewLine]rects\  = \ 
            Table[\n\t\t\t\t\(\((area = 
                      area + \((Max[#1, #3] - Min[#2, #4])\) inc; {RGBColor[
                        1, 0, 0], 
                      Point[{Min[#2, #4], 
                          Last[Last[
                              Sort[Transpose[{func1 /. 
                                      var -> Table[
                                        n + j, {j, 0, inc, inc/10}], 
                                    Table[n + j, {j, 0, inc, inc/10}]}]]]]}], 
                      Point[{Max[#1, #3], 
                          Last[Last[
                              Sort[Transpose[{func2 /. 
                                      var -> Table[
                                        n + j, {j, inc, inc, inc/10}], 
                                    Table[
                                      n + j, {j, inc, inc, inc/10}]}]]]]}], 
                      RGBColor[0, 1, 1], 
                      Rectangle[{Min[#2, #4], n}, {Max[#1, #3], n + inc}], 
                      GrayLevel[0], 
                      Line[{{Min[#2, #4], n}, {Min[#2, #4], 
                            n + inc}, {Max[#1, #3], n + inc}, {Max[#1, #3], 
                            n}, {Min[#2, #4], n}}]})\) &\)[
                Min[func1 /. var \[Rule] Table[n + j, {j, 0, inc, inc/10}]], 
                Max[func2 /. var \[Rule] Table[n + j, {j, 0, inc, inc/10}]], 
                Min[func2 /. var \[Rule] Table[n + j, {j, 0, inc, inc/10}]], 
                Max[func1 /. 
                    var \[Rule] 
                      Table[n + j, {j, 0, inc, 
                          inc/10}]]], \[IndentingNewLine]{n, ymin, 
                ymax - \ inc, 
                inc}]; \[IndentingNewLine]\t\tcotas = {Line[{{func1 /. 
                      var \[Rule] ymin, ymin}, {func2 /. var \[Rule] ymin, 
                    ymin}}], 
              Line[{{func1 /. var \[Rule] ymax, 
                    ymax}, {func2 /. var \[Rule] ymax, 
                    ymax}}]}; \[IndentingNewLine]graf = 
            tipo2[{func1, func2}, \ {var, ymin, ymax}, 
              DisplayFunction \[Rule] Identity]; \ \[IndentingNewLine]\t
          Show[{graf, Graphics[cotas]}, 
            DisplayFunction \[Rule] $DisplayFunction, opts, 
            Epilog \[Rule] {PointSize[0.02], 
                rects}, \[IndentingNewLine]PlotLabel\  \[Rule] 
              StyleForm[
                TraditionalForm["\<Area \[TildeEqual]\>" <> ToString[area]], 
                FontSlant \[Rule] "\<Italic\>", 
                FontSize \[Rule] 12]]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(cicloide := 
        Module[{rueda, rects, varilla, cic}, 
          rueda[t_] := {GrayLevel[ .8], Disk[{t, 1}, 1]}; \ 
          rects = {Thickness[ .01], Line[{{\(-2\), 0}, {14, 0}}]}; \ 
          varilla[r_, 
              t_] := {Line[{{t, 1}, {t - r\ Sin[t], 
                    1 - r\ Cos[t]}}], {PointSize[ .015], Hue[0], 
                Point[{t - r\ Sin[t], 1 - r\ Cos[t]}]}}; \ 
          cic[t_] := 
            ParametricPlot[{u - \ Sin[u], 1 - \ Cos[u]}, {u, 0, t}, \ 
              PlotStyle \[Rule] Hue[0], DisplayFunction \[Rule] Identity]; 
          Do[Show[{Graphics[{rects, rueda[t], varilla[1, t]}], cic[t]}, 
              AspectRatio \[Rule] Automatic, 
              DisplayFunction \[Rule] $DisplayFunction, \ 
              PlotRange \[Rule] {{\(-2\), 14}, {0, 2.1}}], {t,  .01, 
              4  Pi +  .01, 2  Pi/10}]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(cardioide := 
        Module[{rueda, radio, circulo}, 
          rueda[t_] := {GrayLevel[ .7], Disk[{2  Cos[t] + 1, 2  Sin[t]}, 1]}; 
          circulo[t_] := {Hue[0.6], Thickness[ .007], 
              Circle[{2  Cos[t] + 1, 2  Sin[t]}, 1]}; \ 
          radio[t_] := {Line[{{2  Cos[t] + 1, 
                    2  Sin[t]}, {\((1 + Cos[t])\) 4/2 
                       Cos[t], \((1 + Cos[t])\)\ 4/2\ Sin[
                        t]}\ }], {PointSize[ .02], Hue[0], 
                Point[{\((1 + Cos[t])\)\ 4/2  Cos[t], \((1 + Cos[t])\) 4/2 
                       Sin[t]}\ ]}}; \[IndentingNewLine]Do[
            Show[{ParametricPlot[{\((1 + Cos[u])\) 2  Cos[u], 
                    2 \((1 + Cos[u])\) Sin[u]}\ , {u, 0, t +  .01}, 
                  PlotStyle \[Rule] {Hue[0], Thickness[ .007]}, 
                  DisplayFunction \[Rule] Identity], 
                Graphics[{circulo[t], 
                    radio[t], {Hue[0.6], Thickness[ .007], 
                      Circle[{1, 0}, 1]}}]}, AspectRatio \[Rule] Automatic, \ 
              Axes \[Rule] True, Prolog \[Rule] rueda[t], 
              Ticks \[Rule] {{\(-2\), \(-1\), 0, 1, 2, 3, 
                    4}, {\(-1\), \(-2\), \(-3\), 1, 2, 3}}, 
              PlotRange \[Rule] {{\(-3.2\), 4.2}, {\(-3.2\), 3.2}}, 
              DisplayFunction \[Rule] $DisplayFunction], \ \
\[IndentingNewLine]{t, 0, 2  Pi, Pi/10}]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[{
    \(\(ArcLengthPartition[parametrizedCurve_Function, {tmin_, tmax_}, 
          n_] := \(Module[{a, b, L, s, f, t}, {a, b} = N@{tmin, tmax}; 
            L = NIntegrate[
                Sqrt[Plus @@ \((\(parametrizedCurve'\)[t]^2)\)], {t, a, 
                  b}]; \[IndentingNewLine]s = \(NDSolve[{\(f'\)[t] \[Equal] 
                      Sqrt[Plus @@ \((\(parametrizedCurve'\)[t]^2)\)], 
                    f@a \[Equal] 0}, f, {t, a - L, b + L}]\)[\([1, 1, 
                  2]\)]; \[IndentingNewLine]Transpose[\(t /. 
                    FindRoot[s[t] \[Equal] #, {t, {a, b}}] &\) /@ 
                Range[0, s@b, s@b/n]]]\)[\([1]\)];\)\), "\n", 
    \(\(\(ArcLengthPartition[{exprX_, exprY_}, {t_Symbol, tmin_, tmax_}, n_] := 
        ArcLengthPartition[Function[{t}, {exprX, exprY}], {tmin, tmax}, n] /; 
          NumberQ[N@tmin] && NumberQ[N@tmax] && NumberQ@\(N@n\);\)\(\n\)
    \) (*el\ c\[OAcute]digo\ de\ ArcLengthPartition\ es\ original\ de\ Xah\ \
Lee*) \), "\[IndentingNewLine]", 
    \(\(lineapuntos[{funcx_, funcy_}, {var_, tmin_, tmax_}, n_] := 
        Graphics[{{Hue[0], PointSize[0.02], 
              Map[Point, 
                Transpose[{funcx /. 
                      var \[Rule] 
                        ArcLengthPartition[{funcx, funcy}, {var, tmin, tmax}, 
                          n], funcy /. 
                      var \[Rule] 
                        ArcLengthPartition[{funcx, funcy}, {var, tmin, tmax}, 
                          n]}]]}, {Hue[0], 
              Map[Line, 
                Transpose[{funcx /. 
                      var \[Rule] 
                        ArcLengthPartition[{funcx, funcy}, {var, tmin, tmax}, 
                          n], funcy /. 
                      var \[Rule] 
                        ArcLengthPartition[{funcx, funcy}, {var, tmin, tmax}, 
                          n]}], {0}]}}];\)\), "\n", 
    \(\(arclength[{funcx_, funcy_}, {var_, tmin_, tmax_}, n_, opts___] := 
        Module[{u, v, aproxlong}, 
          u = Drop[
              Transpose[{funcx /. 
                    var \[Rule] 
                      ArcLengthPartition[{funcx, funcy}, {var, tmin, tmax}, 
                        n], funcy /. 
                    var \[Rule] 
                      ArcLengthPartition[{funcx, funcy}, {var, tmin, tmax}, 
                        n]}], \(-1\)]; \[IndentingNewLine]v = 
            Rest[Transpose[{funcx /. 
                    var \[Rule] 
                      ArcLengthPartition[{funcx, funcy}, {var, tmin, tmax}, 
                        n], funcy /. 
                    var \[Rule] 
                      ArcLengthPartition[{funcx, funcy}, {var, tmin, tmax}, 
                        n]}]]; \[IndentingNewLine]aproxlong = 
            Plus @@ Sqrt[Apply[Plus, \((u - v)\)^2, 1]]; 
          Show[{ParametricPlot[{funcx, funcy}, {var, tmin, tmax}, opts, 
                DisplayFunction \[Rule] Identity], 
              lineapuntos[{funcx, funcy}, {var, tmin, tmax}, n]}, 
            DisplayFunction \[Rule] $DisplayFunction, 
            PlotLabel \[Rule] 
              StyleForm[
                TraditionalForm["\<Longitud \[TildeEqual]\>" <> 
                    ToString[aproxlong]], FontSlant \[Rule] "\<Italic\>", 
                FontSize \[Rule] 12]]];\)\)}], "Input",
  InitializationCell->True],

Cell[BoxData[
    RowBox[{
      RowBox[{"fig", ":=", 
        RowBox[{"Module", "[", 
          RowBox[{\({cartesianas}\), ",", 
            
            RowBox[{\(cartesianas[{\[Rho]_, \[Theta]_}] := {\[Rho]\ Cos[\
\[Theta]], \[Rho]\ Sin[\[Theta]]}\), ";", 
              RowBox[{"Show", "[", 
                RowBox[{
                  RowBox[{"{", 
                    
                    RowBox[{\(PolarPlot[
                        1 + Cos[\[Theta]], {\[Theta], \[Pi]/20, \[Pi]/2}, 
                        AspectRatio \[Rule] Automatic, Axes \[Rule] None, 
                        PlotStyle \[Rule] {Thickness[0.007], Hue[0]}, 
                        DisplayFunction \[Rule] Identity]\), ",", 
                      RowBox[{"Graphics", "[", 
                        RowBox[{"{", 
                          
                          RowBox[{\({Thickness[0.007], Hue[0], 
                              Line[{{0.6, \(- .5\)}, 
                                  cartesianas[{1, \[Pi]/2}]}]}\), 
                            ",", \(Line[{{0.6, \(- .5\)}, {2.1, \(- .5\)}}]\),
                             ",", \(Circle[{ .6, \(- .5\)},  .4, {0, \[Pi]/
                                    2 +  .37}]\), 
                            ",", \(Circle[{ .6, \(- .5\)}, 
                              1.1, {0, \[Pi]/20 +  .38}]\), 
                            ",", \(Circle[{ .6, \(- .5\)},  .6, {0, \[Pi]/
                                    2 +  .037}]\), ",", 
                            RowBox[{"Text", "[", 
                              RowBox[{
                                StyleBox["\[Alpha]",
                                  FontSize->14], ",", \({1.6, \(- .2\)}\)}], 
                              "]"}], ",", 
                            RowBox[{"Text", "[", 
                              RowBox[{
                                StyleBox["\[Beta]",
                                  FontSize->14], ",", \({ .85, \(- .25\)}\)}],
                               "]"}], ",", 
                            RowBox[{"Text", "[", 
                              RowBox[{
                                StyleBox["\"\<\[Rho]=f(\[Theta])\>\"",
                                  FontSize->14], ",", \({1.4, 1.25}\)}], 
                              "]"}], ",", 
                            RowBox[{"Text", "[", 
                              RowBox[{"\"\<\!\(\(\*
StyleBox[\"\[Theta]\",\nFontSize->14]\)\_\(k - 1\)\)\>\"", 
                                ",", \({1.2,  .16}\)}], "]"}], ",", 
                            RowBox[{"Text", "[", 
                              RowBox[{"\"\<\!\(\*
StyleBox[\"\[CapitalOmega]\",\nFontSize->18]\)\>\"", ",", \({1.2,  .7}\)}], 
                              "]"}], ",", 
                            RowBox[{"Text", "[", 
                              RowBox[{"\"\<\!\(\(\*
StyleBox[\"\[Theta]\",\nFontSize->14]\)\_k\)\>\"", ",", \({1,  .02}\)}], 
                              "]"}], 
                            ",", \(Circle[{ .6, \(- .5\)},  .8, {0, \[Pi]/
                                    2 -  .255}]\), 
                            ",", \({Thickness[0.006], 
                              Line[{{0.6, \(- .5\)}, 
                                  cartesianas[{1 + 
                                        Cos[\[Pi]/2 -  .7], \[Pi]/
                                        2 -  .7}]}]}\), 
                            ",", \({Thickness[0.006], 
                              Line[{{0.6, \(- .5\)}, 
                                  cartesianas[{1 + 
                                        Cos[\[Pi]/2\  -  .4], \[Pi]/
                                        2 -  .4}]}]}\), 
                            ",", \({Thickness[0.007], Hue[0], 
                              Line[{{0.6, \(- .5\)}, 
                                  cartesianas[{1 + Cos[\[Pi]/20], \[Pi]/
                                        20}]}]}\)}], "}"}], "]"}]}], "}"}], 
                  ",", \(Prolog \[Rule] {{Hue[ .5], 
                        Disk[{ .6, \(- .5\)}, 
                          1.775, {\[Pi]/2 -  .255, \[Pi]/
                                2 +  .037}]}, {Dashing[{ .01,  .01}], 
                        Circle[{ .6, \(- .5\)}, 
                          1.775, {\[Pi]/2 -  .255, \[Pi]/2 +  .037}]}}\), 
                  ",", \(AspectRatio \[Rule] Automatic\), 
                  ",", \(PlotRange \[Rule] {{\(- .6\), 2.1}, {\(- .6\), 2}}\),
                   ",", \(ImageSize \[Rule] {394, 379.375}\), 
                  ",", \(DisplayFunction \[Rule] $DisplayFunction\), 
                  ",", \(TextStyle \[Rule] {FontSize \[Rule] 14, 
                      FontWeight -> "\<Bold\>"}\)}], "]"}]}]}], "]"}]}], 
      ";"}]], "Input",
  InitializationCell->True],

Cell[BoxData[
    RowBox[{
      RowBox[{"fig2", ":=", 
        RowBox[{"Show", "[", 
          RowBox[{
            RowBox[{"Graphics", "[", 
              RowBox[{"{", 
                
                RowBox[{\(Circle[{2, 2}, {1, 1.5}]\), 
                  ",", \(Circle[{2, 2}, {1/2, 1.5}, {\[Pi]/2, 3  \[Pi]/2}]\), 
                  ",", \({Hue[ .5], Disk[{2, 2}, {1/2 -  .01, 1.5}]}\), 
                  ",", \(Line[{{ .8, 
                        3.5}, { .8, \(- .1\)}, {3.2, \(- .1\)}}]\), 
                  ",", \(Text[Y, {0.09, \(-1.8\)}]\), 
                  ",", \(Text[Z, {0.85, 3.4}]\), 
                  ",", \(Text[X, {3.15, 0.1}]\), 
                  ",", \(Text[a, {1, \(-0.3\)}]\), 
                  ",", \(Text[b, {3, \(-0.3\)}]\), 
                  ",", \(Text[x, {2.5, \(-0.3\)}]\), ",", 
                  RowBox[{"Text", "[", 
                    RowBox[{"\"\<\!\(\*
StyleBox[\"\[CapitalOmega]\",\nFontSize->18]\)\!\(\*
StyleBox[\"(\",\nFontSize->18]\)\!\(\*
StyleBox[\"x\",\nFontSize->18]\)\!\(\*
StyleBox[\")\",\nFontSize->18]\)\>\"", ",", \({2, 2}\)}], "]"}], ",", 
                  RowBox[{"Text", "[", 
                    RowBox[{"\"\<\!\(\*
StyleBox[\"\[CapitalOmega]\",\nFontSize->18]\)\>\"", ",", \({3, 3}\)}], "]"}],
                   ",", \(Line[{{ .8, \(- .1\)}, {0.1, \(-2\)}}]\), 
                  ",", \(Circle[{2, 2}, {1, \((1.5)\)/2}, {\[Pi], 
                      2  \[Pi]}]\), 
                  ",", \({Dashing[{ .012,  .012}], 
                    Line[{{1.5, \(-2\)}, {1.5, 3.95}}]}\), 
                  ",", \({Dashing[{ .012,  .012}], 
                    Line[{{2.5, 3.89}, {1.5, 3.95}}]}\), 
                  ",", \({Dashing[{ .012,  .012}], 
                    Line[{{2.5, 3.89}, {2.5, \(- .11\)}}]}\), 
                  ",", \(Line[{{3, 2}, {3, \(- .1\)}}]\), 
                  ",", \(Line[{{1, 2}, {1, \(- .1\)}}]\), 
                  ",", \({Dashing[{ .012,  .012}], 
                    Line[{{2.5, \(- .11\)}, {1.5, \(-2\)}}]}\), 
                  ",", \({Dashing[{ .012,  .012}], 
                    Circle[{2, 2}, {1/2, 1.5}, {3  \[Pi]/2, 5  \[Pi]/2}]}\), 
                  ",", \({Dashing[{ .012,  .012}], 
                    Circle[{2, 2}, {1, \((1.5)\)/2}, {0, \[Pi]}]}\)}], "}"}], 
              "]"}], ",", \(AspectRatio \[Rule] 1/2.2\), 
            ",", \(ImageSize \[Rule] {681, 226.813}\), 
            ",", \(PlotRange \[Rule] {{0, 3.3}, {\(-2.2\), 4}}\), 
            ",", \(TextStyle \[Rule] {FontSize \[Rule] 14, 
                FontWeight -> "\<Bold\>"}\)}], "]"}]}], ";"}]], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(fig3 := 
        Module[{f}, 
          f[x_] = Apply[Plus, 
              Table[\((\(-UnitStep[x - \((k + 1/5)\)]\) + 
                      UnitStep[x - k])\) \@\(1 - k\^2/4\), {k, \(-2\), 
                  2 + 1/5, 1/5}]]; 
          SurfaceOfRevolution[f[x], {x, \(-2\), 2}, 
            RevolutionAxis \[Rule] {1, 0, 0}, AspectRatio \[Rule] Automatic, 
            PlotPoints \[Rule] 100, 
            ViewPoint -> {\(-0.012\), \ \(-3.277\), \ 0.845}, 
            ImageSize \[Rule] {510, 283.75}, Axes \[Rule] False, 
            Boxed \[Rule] False, 
            LightSources \[Rule] {{{2, 1, 1}, RGBColor[1, 0, 0]}, {{0, 0, 0}, 
                  RGBColor[0, 1, 1]}, {{\(-2\), 1, 1}, 
                  RGBColor[0, 1, 1]}}]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(stepfunc[func_, {var_, xmin_, xmax_}, n_] := 
      Apply[Plus, 
        Table[\((\(-UnitStep[x - \((k + N[\((xmax - xmin)\)/n])\)]\) + 
                UnitStep[x - k])\) \((func /. var \[Rule] k)\), {k, xmin, 
            xmax, N[\((xmax - xmin)\)/n]}]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(disco1[func_, {var_, xmin_, xmax_, sub_}, 
          opts___] := \[IndentingNewLine]\t
        Module[{rects, n, graf, inc, cotas}, \[IndentingNewLine]inc = 
            N[\((xmax\  - \ xmin)\)/sub]; \[IndentingNewLine]rects\  = \ 
            Table[\n\t\t\t\t\(\((Line[{{n, 0}, {n + inc, 
                          0}, {n + inc, #}, {n, #}, {n, 0}}])\) &\)[
                Min[func /. var \[Rule] {n, n + inc}]], {n, xmin, 
                xmax - \ inc, 
                inc}]; \[IndentingNewLine]\t\tcotas = {Line[{{xmin, 
                    0}, {xmin, func /. var \[Rule] xmin}}], 
              Line[{{xmax, 0}, {xmax, func /. var \[Rule] xmax}}], 
              Line[{{xmin, 0}, {xmax, 0}}]}; \[IndentingNewLine]graf = 
            Plot[func, \ {var, xmin, xmax}, 
              DisplayFunction \[Rule] Identity]; \ \[IndentingNewLine]\t
          Show[{graf, Graphics[{cotas, rects}]}, opts, 
            AxesOrigin \[Rule] {Max[xmin -  .2, 0], 0}]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    RowBox[{
      RowBox[{"fig4", ":=", 
        RowBox[{"Show", "[", 
          RowBox[{
            RowBox[{"{", 
              
              RowBox[{\(Plot[{2 + Sin[x], \(-2\) - Sin[x]}, {x,  .5, 
                    2  \[Pi] -  .5}, AspectRatio \[Rule] Automatic, 
                  DisplayFunction \[Rule] Identity]\), ",", 
                RowBox[{"Graphics", "[", 
                  RowBox[{"{", 
                    
                    RowBox[{\(Circle[{ .5, 0}, { .3, 2 + Sin[ .5]}]\), 
                      ",", \(Circle[{3, 0}, { .25, 
                          2 + Sin[3]}, {\(-\[Pi]\)/2, \[Pi]/2}]\), 
                      ",", \(Circle[{3 -  .7, 0}, { .25, 
                          2 + Sin[3 -  .7]}, {\(-\[Pi]\)/2, \[Pi]/2}]\), 
                      ",", \({Dashing[{ .01,  .01}], 
                        Circle[{3 -  .7, 0}, { .25, 
                            2 + Sin[3 -  .7]}, {\[Pi]/2, 3  \[Pi]/2}]}\), 
                      ",", \({Dashing[{ .01,  .01}], 
                        Circle[{2  \[Pi] -  .5, 0}, { .23, 
                            2 + Sin[2  \[Pi] -  .5]}, {\[Pi]/2, 
                            3  \[Pi]/2}]}\), 
                      ",", \({Dashing[{ .01,  .01}], 
                        Line[{{2.3, 0}, {2.3, 2 + Sin[2.3]}}]}\), 
                      ",", \({Dashing[{ .01,  .01}], 
                        Line[{{3, 0}, {3, 2 + Sin[3]}}]}\), 
                      ",", \({Dashing[{ .01,  .01}], 
                        Circle[{3, 0}, { .25, 2 + Sin[3]}, {\[Pi]/2, 
                            3  \[Pi]/2}]}\), ",", 
                      RowBox[{"Text", "[", 
                        RowBox[{"\"\<\!\(\*
StyleBox[\"a\",\nFontSize->16]\)\>\"", ",", \({ .5, \(- .2\)}\)}], "]"}], ",",
                       
                      RowBox[{"Text", "[", 
                        RowBox[{"\"\<\!\(\*
StyleBox[\"b\",\nFontSize->16]\)\>\"", ",", \({2  \[Pi] -  .5, \(- .2\)}\)}], 
                        "]"}], ",", 
                      RowBox[{"Text", "[", 
                        RowBox[{"\"\<\!\(\*
StyleBox[\"y\",\nFontSize->16]\)\!\(\*
StyleBox[\"=\",\nFontSize->16]\)\!\(\*
StyleBox[\"f\",\nFontSize->16]\)\!\(\*
StyleBox[\"(\",\nFontSize->16]\)\!\(\*
StyleBox[\"x\",\nFontSize->16]\)\!\(\*
StyleBox[\")\",\nFontSize->16]\)\>\"", ",", \({4.5, 1.55}\)}], "]"}], ",", 
                      RowBox[{"Text", "[", 
                        RowBox[{"\"\<\!\(\*
StyleBox[\"S\",\nFontSize->16]\)\!\(\*
StyleBox[\"(\",\nFontSize->16]\)\!\(\*
StyleBox[\"x\",\nFontSize->16]\)\!\(\*
StyleBox[\")\",\nFontSize->16]\)\>\"", ",", \({1.5, 1.35}\)}], "]"}], ",", 
                      RowBox[{"Text", "[", 
                        RowBox[{"\"\<\!\(\*
StyleBox[\"L\",\nFontSize->16]\)\!\(\*
StyleBox[\"(\",\nFontSize->16]\)\!\(\*
StyleBox[\"x\",\nFontSize->16]\)\!\(\*
StyleBox[\")\",\nFontSize->16]\)\>\"", ",", \({2.75, 2.45 + Sin[2.7]}\)}], 
                        "]"}], ",", 
                      RowBox[{"Text", "[", 
                        RowBox[{"\"\<\!\(\*
StyleBox[\"L\",\nFontSize->16]\)\!\(\*
StyleBox[\"(\",\nFontSize->16]\)\!\(\*
StyleBox[\"x\",\nFontSize->16]\)\!\(\*
StyleBox[\"+\",\nFontSize->16]\)\!\(\*
StyleBox[\"h\",\nFontSize->16]\)\!\(\*
StyleBox[\")\",\nFontSize->16]\)\>\"", ",", \({3.65, 2.1 + Sin[3]}\)}], "]"}],
                       ",", 
                      RowBox[{"Text", "[", 
                        RowBox[{"\"\<\!\(\*
StyleBox[\"x\",\nFontSize->14]\)\>\"", ",", \({2.3, \(- .2\)}\)}], "]"}], ",",
                       
                      RowBox[{"Text", "[", 
                        RowBox[{"\"\<\!\(\*
StyleBox[\"x\",\nFontSize->14]\)\!\(\*
StyleBox[\"+\",\nFontSize->14]\)\!\(\*
StyleBox[\"h\",\nFontSize->14]\)\>\"", ",", \({3, \(- .2\)}\)}], "]"}], 
                      ",", \(Circle[{2  \[Pi] -  .5, 0}, { .23, 
                          2 + Sin[2  \[Pi] -  .5]}, {\(-\[Pi]\)/2, \[Pi]/
                            2}]\)}], "}"}], "]"}]}], "}"}], 
            ",", \(AxesOrigin \[Rule] {0, 0}\), 
            ",", \(PlotRange \[Rule] {{\(- .1\), 2  \[Pi] +  .1}, {\(-3.1\), 
                  3.2}}\), ",", \(DisplayFunction \[Rule] $DisplayFunction\), 
            ",", \(Ticks \[Rule] {{{ .5, "\<\>"}, {2.3, "\<\>"}, {3, "\<\>"}, \
{2  \[Pi] -  .5, "\<\>"}}, None}\)}], "]"}]}], ";"}]], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(On[General::"\<spell1\>"]\)], "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["C\[AAcute]lculo de \[AAcute]reas planas", "Section"],

Cell[TextData[{
  "Te recuerdo que si ",
  Cell[BoxData[
      \(TraditionalForm\`f : \([a, b]\) \[Rule] \[DoubleStruckCapitalR]\)]],
  " es una funci\[OAcute]n continua, representamos por ",
  Cell[BoxData[
      FormBox[
        RowBox[{"G", 
          StyleBox["(",
            FontSize->12], 
          StyleBox[\(f, a, b\),
            FontSize->12], 
          StyleBox[")",
            FontSize->12]}], TraditionalForm]]],
  " la regi\[OAcute]n del plano comprendida entre la curva ",
  Cell[BoxData[
      \(TraditionalForm\`y = \ f \((x)\)\)]],
  ", el eje de abscisas y las rectas ",
  Cell[BoxData[
      \(TraditionalForm\`y = a\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`y = b\)]],
  ". Como sabes, el \[AAcute]rea de dicha regi\[OAcute]n viene dada por ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Lambda](G(f, a, b)) = 
        \[Integral]\_a\^b |\( f(x)\) |\[DifferentialD]x\)]],
  " (no suponemos que ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " sea positiva). Es interesante interpretar la integral que proporciona el \
\[AAcute]rea de la siguiente forma. Observa que ",
  Cell[BoxData[
      \(TraditionalForm\`|\( f(x)\) |\)]],
  " es la ",
  StyleBox["longitud",
    FontSlant->"Italic"],
  " del segmento intersecci\[OAcute]n de ",
  Cell[BoxData[
      FormBox[
        RowBox[{"G", 
          StyleBox["(",
            FontSize->12], 
          StyleBox[\(f, a, b\),
            FontSize->12], 
          StyleBox[")",
            FontSize->12]}], TraditionalForm]]],
  " con la recta vertical que pasa por ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, 0)\)\)]],
  ", es decir, ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(|\(f(x)\) |\),
          FontWeight->"Plain"], TraditionalForm]],
    FontWeight->"Bold"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "es la longitud de",
  StyleBox[" ",
    FontWeight->"Bold"],
  "la",
  StyleBox[" secci\[OAcute]n vertical ",
    FontWeight->"Bold"],
  "de ",
  Cell[BoxData[
      FormBox[
        RowBox[{"G", 
          StyleBox["(",
            FontSize->12], 
          StyleBox[\(f, a, b\),
            FontSize->12], 
          StyleBox[")",
            FontSize->12]}], TraditionalForm]]],
  " por el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, 0)\)\)]],
  ", y",
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["el \[AAcute]rea de la regi\[OAcute]n  ",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`G(f, a, b)\)],
    FontSlant->"Italic"],
  StyleBox[" es igual a la integral de las longitudes de sus secciones",
    FontSlant->"Italic"],
  ". Intuitivamente: integrando longitudes obtenemos \[AAcute]reas. Como el \
\[AAcute]rea es invariante por rotaciones, este resultado es tambi\[EAcute]n \
v\[AAcute]lido si consideramos secciones por rectas paralelas a una recta \
cualquiera dada. Deducimos as\[IAcute] el siguiente resultado.\n",
  StyleBox["Principio de Cavalieri",
    FontWeight->"Bold"],
  ". ",
  StyleBox[
  "El \[AAcute]rea de una regi\[OAcute]n plana es igual a la integral de las \
longitudes de sus secciones por rectas paralelas a una recta dada",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ". \nVeamos c\[OAcute]mo se aplica este principio en algunos casos \
concretos."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["  \[CapitalAAcute]rea entre dos curvas", "Section"],

Cell[CellGroupData[{

Cell[TextData[{
  "  ",
  StyleBox["Regiones de tipo I",
    FontSize->16]
}], "Subsubsection",
  FontSize->12],

Cell[TextData[{
  "Supongamos que ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f, g : \([a, b]\) \[Rule] \[DoubleStruckCapitalR]\),
          FontSize->13], TraditionalForm]]],
  " son funciones continuas y llamemos \[CapitalOmega] a la regi\[OAcute]n \
del plano comprendida entre las curvas ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontSize->14], 
          StyleBox["=",
            FontSize->13], 
          StyleBox[" ",
            FontSize->13], 
          StyleBox[\(f \((x)\)\),
            FontSize->13]}], TraditionalForm]]],
  " e ",
  Cell[BoxData[
      \(TraditionalForm\`\(\ y = g(x)\)\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`x\ \[Epsilon]\ [a, b]\)]],
  ". Se dice que \[CapitalOmega] es una regi\[OAcute]n de tipo I. Puedes \
representar gr\[AAcute]ficamente dicha regi\[OAcute]n con la orden \
\"tipo1[{f,g},{x,a,b},opts]\" (que admite opciones como \"Plot\"). \
Experimenta con distintas funciones. Aqu\[IAcute] tienes unos ejemplos."
}], "Text"],

Cell[BoxData[
    \(\(tipo1[{Cos[x], 2 + Sin[x]}, {x, 0, 2  \[Pi]}, 
        Fills \[Rule] RGBColor[1, 1, 0]];\)\)], "Input"],

Cell[BoxData[
    \(\(tipo1[{Sin[x], Cos[x]}, {x, 0, 2  Pi}, 
        PlotStyle -> {{Hue[0], Thickness[ .007]}, {Hue[ .65], 
              Thickness[ .007]}}];\)\)], "Input"],

Cell[BoxData[
    \(\(tipo1[{x\^2, 4 - x\^2}, {x, \(-2\), 2}, 
        PlotStyle -> {{Hue[0], Thickness[ .007]}, {Hue[ .65], 
              Thickness[ .007]}}];\)\)], "Input"],

Cell[TextData[{
  "Es evidente que las longitudes de las secciones verticales de \
\[CapitalOmega] son iguales a ",
  Cell[BoxData[
      \(TraditionalForm\`\(| f(x) - g(x) | \)\)]],
  " por lo que su \[AAcute]rea viene dada por"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`\[Lambda](\[CapitalOmega]) = 
      \[Integral]\_a\%b\( | f(x) - g(x) | \[DifferentialD]x\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Observa que esta integral expresa el \[AAcute]rea de \[CapitalOmega] como \
l\[IAcute]mite de las sumas de Riemann ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Sum]\+\(k = 1\)\%n\( | f(t\_k) - g(t\_k) | 
          \((x\_\(k + 1\) - x\_k)\)\)\)]],
  ", lo que tiene una sencilla interpretaci\[OAcute]n que puedes visualizar \
con la orden \"tipo1sup[{f,g},{x,a,b,n},opts]\" (admite opciones como \
\"Plot\") que representa aproximaciones superiores al \[AAcute]rea de \
\[CapitalOmega] dividiendo ",
  Cell[BoxData[
      \(TraditionalForm\`\([a, b]\)\)]],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " subintervalos ",
  Cell[BoxData[
      \(TraditionalForm\`\([x\_k, x\_\(k + 1\)]\)\)]],
  " y eligiendo en cada uno de ellos el punto ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(t\_k\), " ", "\[Epsilon]", "  ", 
          FormBox[\([x\_k, x\_\(k + 1\)]\),
            "TraditionalForm"], " "}], TraditionalForm]]],
  " en el que la funci\[OAcute]n",
  Cell[BoxData[
      \(TraditionalForm\`\(| f - g | \)\)]],
  " alcanza su m\[AAcute]ximo absoluto en dicho subintervalo. Significado an\
\[AAcute]logo tiene el comando \"tipo1inf[{f,g},{x,a,b,n},opts]\". Prueba con \
distintas funciones. Los siguientes ejemplos son ilustrativos."
}], "Text"],

Cell[BoxData[
    \(\(tipo1sup[{Cos[x], 2 + Sin[x]}, {x, 0, 2  \[Pi], 24}, 
        Axes -> True];\)\)], "Input"],

Cell[BoxData[
    \(\(tipo1inf[{Cos[x], 2 + Sin[x]}, {x, 0, 2  \[Pi], 24}, 
        Axes -> True];\)\)], "Input"],

Cell["\<\
Las siguientes animaciones muestarn c\[OAcute]mo las aproximaciones van \
mejorando conforme aumenta el n\[UAcute]mero de intervalos de la partici\
\[OAcute]n.\
\>", "Text"],

Cell[BoxData[{
    \(\(Do[
        tipo1sup[{Cos[x], 2 + Sin[x]}, {x, 0, 2  \[Pi], k}, 
          Axes \[Rule] True], {k, 12, 36, 3}];\)\), "\n", 
    \(\(SelectionMove[EvaluationNotebook[], All, GeneratedCell];\)\), "\n", 
    \(FrontEndTokenExecute["\<CellGroup\>"]\), "\n", 
    \(FrontEndTokenExecute["\<OpenCloseGroup\>"]\)}], "Input"],

Cell[BoxData[{
    \(\(Do[
        tipo1inf[{Cos[x], 2 + Sin[x]}, {x, 0, 2  \[Pi], k}, 
          Axes -> True], {k, 12, 36, 3}];\)\), "\n", 
    \(\(SelectionMove[EvaluationNotebook[], All, GeneratedCell];\)\), "\n", 
    \(FrontEndTokenExecute["\<CellGroup\>"]\), "\n", 
    \(FrontEndTokenExecute["\<OpenCloseGroup\>"]\)}], "Input"],

Cell[TextData[{
  "En la pr\[AAcute]ctica, es frecuente describir una regi\[OAcute]n de tipo \
I como ",
  StyleBox["\"la regi\[OAcute]n comprendida entre las curvas",
    FontSlant->"Italic"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`y = \ f(x)\)]],
  " ",
  StyleBox["e",
    FontSlant->"Italic"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\(\ y = g(x)\)\)]],
  StyleBox["\"",
    FontSlant->"Italic"],
  " sin precisar el intervalo de la variable ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". En estos casos, se entiende que se trata de la ",
  StyleBox["regi\[OAcute]n acotada",
    FontSlant->"Italic"],
  " comprendidad entre las dos gr\[AAcute]ficas; la cual debe determinarse \
calculando los puntos de intersecci\[OAcute]n de las mismas, es decir, \
resolviendo la ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f(x) = g(x)\)]],
  " lo que tambi\[EAcute]n nos proporciona los l\[IAcute]mites de integraci\
\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  ". "
}], "Text"],

Cell[TextData[{
  StyleBox["Cuando la funci\[OAcute]n ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`f\  - \ g\)],
    FontWeight->"Bold"],
  StyleBox[" no tiene signo constante en el intervalo ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\([a, b]\)\)],
    FontWeight->"Bold"],
  StyleBox[", para calcular la integral ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\_a\^b\(\(|\)\(f(x) - 
            g(x)\)\(|\)\(\[DifferentialD]x\)\)\)],
    FontWeight->"Bold"],
  StyleBox[" se descompone dicho  intervalo en intervalos en los que la funci\
\[OAcute]n ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\(\(f\)\(\ \)\(-\ g\)\(\ \)\)\)],
    FontWeight->"Bold"],
  StyleBox["es siempre positiva o siempre negativa, lo que permite quitar el \
valor absoluto en el integrando. ",
    FontWeight->"Bold"],
  "\nA veces interesa expresar una regi\[OAcute]n de tipo I como \
uni\[OAcute]n de dos o m\[AAcute]s regiones de tipo I disjuntas y m\[AAcute]s \
sencillas, entonces su \[AAcute]rea es la suma de las \[AAcute]reas de cada \
una de dichas regiones."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["  Ejemplo 1", "Subsubsection"],

Cell[TextData[{
  "Calcular el \[AAcute]rea de la region \[CapitalOmega] comprendida entre la \
par\[AAcute]bola ",
  Cell[BoxData[
      \(TraditionalForm\`y = \(-x\^2\) - 2  x + 10\)]],
  " y la recta ",
  Cell[BoxData[
      \(TraditionalForm\`y = 2  x - 1\)]],
  "."
}], "Text"],

Cell["\<\
Calculamos los puntos donde se cortan la par\[AAcute]bola y la recta. \
\>", "Text"],

Cell[BoxData[
    \({a, b} = 
      x /. Solve[2  x - 1 \[Equal] \(-x\^2\) - 2  x + 10, x]\)], "Input"],

Cell["\<\
Representaremos la regi\[OAcute]n \[CapitalOmega]. Puedes usar para ello la \
orden \"Plot[ ]\". \
\>", "Text"],

Cell[BoxData[
    \(\(Plot[{\(-x\^2\) - 2  x + 10, 2  x - 1}, {x, a, b}, 
        PlotStyle -> {{Hue[0], Thickness[ .007]}, {Hue[ .65], 
              Thickness[ .007]}}];\)\)], "Input"],

Cell["\<\
Tambi\[EAcute]n podemos usar \"FilledPlot[ ]\" que dibuja en azul la zona \
comprendida entre la recta y la par\[AAcute]bola.\
\>", "Text"],

Cell[BoxData[
    \(\(FilledPlot[{\(-x\^2\) - 2  x + 10, 2  x - 1}, {x, a, 
          b}];\)\)], "Input"],

Cell[TextData[{
  "Es claro que para  ",
  Cell[BoxData[
      \(TraditionalForm\`x\ \[Epsilon]\ [\(-2\) - \@15, \(-2\) + \@15]\)]],
  "   la par\[AAcute]bola est\[AAcute] por encima de la recta. Por tanto, el \
\[AAcute]rea de \[CapitalOmega] viene dada por \t      \t \t\t"
}], "Text"],

Cell[BoxData[{
    \(Integrate[\(-x^2\) - 2  x + 10 - \((2  x - 1)\), {x, a, b}]\), "\n", 
    \(Clear[a, b]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["  Ejemplo 2", "Subsubsection"],

Cell[TextData[{
  "Calcular el \[AAcute]rea de la regi\[OAcute]n \[CapitalOmega] comprendida \
entre la par\[AAcute]bola ",
  Cell[BoxData[
      \(TraditionalForm\`y\^2 = x\)]],
  " y la recta ",
  Cell[BoxData[
      \(TraditionalForm\`y = x - 2\)]],
  "."
}], "Text"],

Cell[TextData[{
  "Calculemos los puntos de corte de la recta",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          FormBox[\(y = x - 2\),
            "TraditionalForm"]}], TraditionalForm]]],
  " con la par\[AAcute]bola ",
  Cell[BoxData[
      \(TraditionalForm\`y\^2 = x\)]],
  ". "
}], "Text"],

Cell[BoxData[
    \(x /. Solve[x \[Equal] \((x - 2)\)\^2, x]\)], "Input"],

Cell[BoxData[
    \(\(Plot[{\@x, x - 2, \(-\@x\)}, {x, 0, 4}, 
        PlotStyle -> {{Hue[0], Thickness[ .007]}, {Hue[ .65], 
              Thickness[ .007]}}];\)\)], "Input"],

Cell[TextData[{
  "F\[IAcute]jate en que la  par\[AAcute]bola ",
  Cell[BoxData[
      \(TraditionalForm\`y\^2 = x\)]],
  " es la uni\[OAcute]n de las dos curvas ",
  Cell[BoxData[
      \(TraditionalForm\`y = \@x\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`y = \(-\@x\)\)]],
  ", por lo que la frontera de \[CapitalOmega] est\[AAcute] determinada por \
dichas curvas y la recta ",
  Cell[BoxData[
      \(TraditionalForm\`y = x - 2\)]],
  ". Es claro que \[CapitalOmega] es uni\[OAcute]n de dos regiones de tipo I. \
"
}], "Text"],

Cell[BoxData[{
    \(\(\[CapitalOmega]1 = 
        FilledPlot[{\(-\@x\), \@x}, {x, 0, 1}, 
          Fills \[Rule] RGBColor[1, 1, 0], 
          DisplayFunction -> Identity];\)\), "\n", 
    \(\(\[CapitalOmega]2 = 
        FilledPlot[{x - 2, \@x}, {x, 1, 4}, 
          DisplayFunction -> Identity];\)\), "\n", 
    \(\(Show[{\[CapitalOmega]1, \[CapitalOmega]2, 
          Graphics[{Text[\*"\"\<\!\(\[CapitalOmega]\_1\)\>\"", { .6,  .3}], 
              Text[\*"\"\<\!\(\[CapitalOmega]\_2\)\>\"", {1.9,  .8}]}]}, 
        Ticks \[Rule] {Range[1, 4], Range[\(-1\), 2]}, 
        DisplayFunction -> $DisplayFunction, 
        TextStyle \[Rule] {FontSize \[Rule] 12, 
            FontWeight -> "\<Bold\>"}];\)\)}], "Input"],

Cell[TextData[{
  "Tenemos que el \[AAcute]rea de \[CapitalOmega] viene dada por  ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Lambda](\[CapitalOmega]) = 
        \[Lambda](\[CapitalOmega]1) + \[Lambda](\[CapitalOmega]2)\)]],
  "=",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Integral]\_0\%1\((\@x - \((\(-\@x\))\))\) \[DifferentialD]x\  + \ 
        \[Integral]\_1\%4\((\@x - \((x - 2)\))\) \[DifferentialD]x\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(Integrate[\@x - \((\(-\@x\))\), {x, 0, 1}] + 
      Integrate[\@x - \((x - 2)\), {x, 1, 4}]\)], "Input"],

Cell[TextData[{
  "Observa que \[CapitalOmega] es ella misma una regi\[OAcute]n de tipo I \
definida por las funciones ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox["f",
            "TraditionalForm"], ",", 
          FormBox[\(g : \([0, 4]\) \[RightArrow] \[DoubleStruckCapitalR]\),
            "TraditionalForm"]}], TraditionalForm]]],
  " dadas por ",
  Cell[BoxData[
      \(TraditionalForm\`g(x) = \@x\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`f(x) = \(-\@x\)\)]],
  ", para ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] \ x \[LessEqual] \ 1\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`f(x) = x - 2\)]],
  ", para ",
  Cell[BoxData[
      \(TraditionalForm\`1 \[LessEqual] \ x \[LessEqual] \ 4\)]],
  ".  "
}], "Text"],

Cell[BoxData[{
    \(\(Clear[f, g];\)\), "\n", 
    \(\(f[x_] := \(-\@x\) /; 
          0 \[LessEqual] x \[LessEqual] 1;\)\ \), "\[IndentingNewLine]", 
    \(\(f[x_] := x - 2 /; 1 \[LessEqual] x \[LessEqual] 4;\)\), "\n", 
    \(\(g[x_] := \@x;\)\), "\n", 
    \(tipo1[{f[x], g[x]}, {x, 0, 4}]; Clear[f, g];\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["  Regiones de tipo II", "Subsubsection"],

Cell[TextData[{
  "Supongamos que ",
  Cell[BoxData[
      \(TraditionalForm\`f, 
      g : \([a, b]\) \[Rule] \[DoubleStruckCapitalR]\)]],
  " son funciones continuas y llamemos \[CapitalOmega] a la regi\[OAcute]n \
del plano comprendida entre las curvas ",
  Cell[BoxData[
      \(TraditionalForm\`x = \ f(y)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\(\ x = g(y)\)\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`y\ \[Epsilon]\ [a, b]\)]],
  ". Se dice que \[CapitalOmega] es una regi\[OAcute]n de tipo II. Puedes \
representar gr\[AAcute]ficamente una regi\[OAcute]n de tipo II con la orden \
\"tipo2[{f,g},{y,a,b},opts]\" (que admite opciones como \"Show\"). \
Experimenta con distintas funciones. Observa que las regiones de tipo II son \
las sim\[EAcute]tricas de las regiones de tipo I respecto de la recta ",
  Cell[BoxData[
      \(TraditionalForm\`y = x\)]],
  ". Es decir, una regi\[OAcute]n de tipo II es una regi\[OAcute]n de tipo I \
vista desde el eje de ordenadas. Aqu\[IAcute] tienes unos ejemplos."
}], "Text"],

Cell[BoxData[
    \(\(tipo2[{Cos[y], 2 + Sin[y]}, {y, 0, 2  \[Pi]}, 
        AxesFront \[Rule] True];\)\)], "Input"],

Cell[BoxData[
    \(\(tipo2[{y\^2, 4 - y\^2}, {y, \(-2\), 2}, 
        AxesFront \[Rule] True];\)\)], "Input"],

Cell[TextData[{
  "Es evidente que las longitudes de las ",
  StyleBox["secciones horizontales",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "de \[CapitalOmega] son iguales a ",
  Cell[BoxData[
      \(TraditionalForm\`\(| f(y) - g(y) | \)\)]],
  " por lo que su \[AAcute]rea viene dada por"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`\[Lambda](\[CapitalOmega]) = 
      \[Integral]\_a\%b\( | f(y) - g(y) | \[DifferentialD]y\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Observa que esta integral expresa el \[AAcute]rea de \[CapitalOmega] como \
l\[IAcute]mite de las sumas de Riemann ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\+\(k = 1\)\%n\(\(|\)\(f(t\_k) - 
            g(t\_k)\)\(|\)\((y\_\(k + 1\) - y\_k)\)\)\)]],
  ", lo que tiene una sencilla interpretaci\[OAcute]n que puedes visualizar \
con la orden \"tipo2sup[{f,g},{y,a,b,n},opts]\" (admite opciones como \
\"Show\") que representa aproximaciones superiores al \[AAcute]rea de \
\[CapitalOmega] dividiendo el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([a, b]\)\)]],
  " ",
  StyleBox["del eje de ordenadas",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " subintervalos ",
  Cell[BoxData[
      \(TraditionalForm\`\([y\_k, y\_\(k + 1\)]\)\)]],
  " y eligiendo en cada uno de ellos el punto ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(t\_k\), " ", "\[Epsilon]", "  ", 
          FormBox[\([y\_k, y\_\(k + 1\)]\),
            "TraditionalForm"], " "}], TraditionalForm]]],
  " en el que la funci\[OAcute]n",
  Cell[BoxData[
      \(TraditionalForm\`\(\(|\)\(f - g\)\(|\)\)\)]],
  " alcanza su m\[AAcute]ximo absoluto en dicho subintervalo. Significado an\
\[AAcute]logo tiene el comando \"tipo1inf[{f,g},{y,a,b,n},opts]\". Prueba con \
distintas funciones. Los siguientes ejemplos son ilustrativos."
}], "Text"],

Cell[BoxData[
    \(\(tipo2sup[{Cos[x], 2 + Sin[x]}, {x, 0, 2  \[Pi], 24}, Axes -> True]; 
    \)\)], "Input"],

Cell[BoxData[
    \(\(tipo2inf[{Cos[x], 2 + Sin[x]}, {x, 0, 2  \[Pi], 24}, Axes -> True]; 
    \)\)], "Input"],

Cell["\<\
Las siguientes animaciones muestarn c\[OAcute]mo las aproximaciones van \
mejorando conforme aumenta el n\[UAcute]mero de intervalos de la partici\
\[OAcute]n.\
\>", "Text"],

Cell[BoxData[{
    \(Do[tipo2sup[{Cos[x], 2 + Sin[x]}, {x, 0, 2  \[Pi], k}, 
        Axes -> True], {k, 12, 36, 3}]\), "\n", 
    \(\(SelectionMove[EvaluationNotebook[], All, GeneratedCell];\)\), "\n", 
    \(FrontEndTokenExecute["\<CellGroup\>"]\), "\n", 
    \(FrontEndTokenExecute["\<OpenCloseGroup\>"]\)}], "Input"],

Cell[BoxData[{
    \(Do[tipo2inf[{Cos[x], 2 + Sin[x]}, {x, 0, 2  \[Pi], k}, 
        Axes -> True], {k, 12, 36, 3}]\), "\n", 
    \(\(SelectionMove[EvaluationNotebook[], All, GeneratedCell];\)\), "\n", 
    \(FrontEndTokenExecute["\<CellGroup\>"]\), "\n", 
    \(FrontEndTokenExecute["\<OpenCloseGroup\>"]\)}], "Input"],

Cell[TextData[{
  "Es importante advertir que la distinci\[OAcute]n entre regiones de tipo I \
y de tipo II es tan s\[OAcute]lo una cuesti\[OAcute]n de conveniencia. No son \
conjuntos de distinta naturaleza sino formas distintas de describir un \
conjunto. En la pr\[AAcute]tica te vas a encontrar siempre con regiones que \
puedes considerar tanto de tipo I como de tipo II y deber\[AAcute]s elegir la \
descripci\[OAcute]n que m\[AAcute]s facilite el c\[AAcute]lculo de la \
correspondiente integral. De todas formas, no debes olvidar que basta cambiar \
la variable ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " por la variable ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " para convertir una regi\[OAcute]n de tipo II en otra de tipo I; por \
tanto, si en un ejercicio resulta conveniente considerar la regi\[OAcute]n \
cuya \[AAcute]rea quieres calcular como una regi\[OAcute]n de tipo II y te \
encuentras m\[AAcute]s c\[OAcute]modo trabajando con regiones de tipo I, ya \
sabes lo que tienes que hacer.\nEn la pr\[AAcute]ctica, es frecuente \
describir una regi\[OAcute]n de tipo II como ",
  StyleBox["\"la regi\[OAcute]n comprendida entre las curvas",
    FontSlant->"Italic"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`x = f(y)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\(\ x = g(y)\)\)]],
  StyleBox["\"",
    FontSlant->"Italic"],
  " sin precisar el intervalo de la variable ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  ". En estos casos, se entiende que se trata de la ",
  StyleBox["regi\[OAcute]n acotada",
    FontSlant->"Italic"],
  " comprendidad entre las dos curvas; la cual debe determinarse calculando \
los puntos de intersecci\[OAcute]n de las mismas, es decir, resolviendo la \
ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f(y) = g(y)\)]],
  " lo que tambi\[EAcute]n nos proporciona los l\[IAcute]mites de integraci\
\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  ". \n",
  StyleBox["Cuando la funci\[OAcute]n ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`f\  - \ g\)],
    FontWeight->"Bold"],
  StyleBox[" no tiene signo constante en el intervalo ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\([a, b]\)\)],
    FontWeight->"Bold"],
  StyleBox[", para calcular la integral ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm
      \`\[Integral]\_a\^b\( | f(y) - g(y) | \[DifferentialD]y\)\)],
    FontWeight->"Bold"],
  StyleBox[
  " se descompone dicho  intervalo en intervalos en los que la \
funci\[OAcute]n ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\(f\ \(-\ g\)\ \)\)],
    FontWeight->"Bold"],
  StyleBox[
  "es siempre positiva o siempre negativa, lo que permite quitar el valor \
absoluto en el integrando. ",
    FontWeight->"Bold"],
  "\nA veces interesa expresar una regi\[OAcute]n de tipo II como \
uni\[OAcute]n de dos o m\[AAcute]s regiones de tipo II disjuntas y \
m\[AAcute]s sencillas, entonces su \[AAcute]rea es la suma de las \
\[AAcute]reas de cada una de dichas regiones.\nAunque las regiones que hemos \
considerado antes son acotadas, la idea de regi\[OAcute]n no acotada de tipo \
I y de tipo II se entiende por s\[IAcute] sola y no precisa nueva definici\
\[OAcute]n. Los resultados anteriores se extienden f\[AAcute]cilmente al caso \
de regiones no acotadas de tipo I y de tipo II, la \[UAcute]nica diferencia \
es que ahora las \[AAcute]reas vendr\[AAcute]n dadas por integrales de \
funciones no acotadas o en intervalos no acotados. Como ya debes de saber, \
para calcular dichas integrales tienes que evaluar una primitiva y calcular \
su l\[IAcute]mite. "
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["  Ejemplo 3", "Subsubsection"],

Cell[TextData[{
  "Calcular el \[AAcute]rea de la regi\[OAcute]n \[CapitalOmega] comprendida \
entre la par\[AAcute]bola ",
  Cell[BoxData[
      \(TraditionalForm\`y\^2 = x\)]],
  " y la recta ",
  Cell[BoxData[
      \(TraditionalForm\`y = x - 2\)]],
  ".\nSe trata del mismo ejercicio considerado en el ejemplo 2. Recuerda que, \
para calcular el \[AAcute]rea, expres\[AAcute]bamos \[CapitalOmega] como uni\
\[OAcute]n de dos regiones de tipo I. De hecho, la propia regi\[OAcute]n \
\[CapitalOmega] es de tipo I. Sin embargo, los c\[AAcute]lculos son \
m\[AAcute]s sencillos si consideramos \[CapitalOmega] como la regi\[OAcute]n \
de tipo II limitada por las curvas ",
  Cell[BoxData[
      \(TraditionalForm\`x = y\^2\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\(\ x = y + 2\)\)]],
  " cuyos puntos de intersecci\[OAcute]n se obtiene para ",
  Cell[BoxData[
      \(TraditionalForm\`y = \(-1\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`y = 2\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(\(tipo2[{y\^2, y + 2}, {y, \(-1\), 2}, AxesFront \[Rule] True]; \)\)], 
  "Input"],

Cell[TextData[{
  "Por tanto, el \[AAcute]rea de \[CapitalOmega] viene dada por ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Lambda](\[CapitalOmega]) = 
        \[Integral]\_\(-1\)\%2\((y + 2 - y\^2)\) \[DifferentialD]y\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(Integrate[y + 2 - y\^2, {y, \(-1\), 2}]\)], "Input"],

Cell[TextData[
"Si quieres ver \[CapitalOmega] como una regi\[OAcute]n de tipo I m\[AAcute]s \
sencilla que la considerada en el ejemplo 2, puedes simetrizar su \
gr\[AAcute]fica como sigue. "], "Text"],

Cell[BoxData[
    \(\(tipo1[{x\^2, x + 2}, {x, \(-1\), 2}, AxesFront \[Rule] True]; \)\)], 
  "Input"],

Cell[TextData[{
  "Aunque la regi\[OAcute]n as\[IAcute] obtenida no es la misma \
\[CapitalOmega] tiene, sin embargo, igual \[AAcute]rea que \[CapitalOmega]  \
pues ambas regiones se transforman una en otra por medio de una simetr\
\[IAcute]a respecto de la recta ",
  Cell[BoxData[
      \(TraditionalForm\`y = x\)]],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicios", "Subsection"],

Cell[TextData[{
  StyleBox["1",
    FontWeight->"Bold"],
  " Calcula las \[AAcute]reas de las regiones del plano limitadas por las \
siguientes curvas.\n",
  StyleBox["a)",
    FontWeight->"Bold"],
  "  ",
  Cell[BoxData[
      \(TraditionalForm\`x = 12  y\^2 - 12  y\^3\)]],
  "  y  ",
  Cell[BoxData[
      \(TraditionalForm\`\(\ x = 2  y\^2 - 2  y\)\)]],
  ".\n",
  StyleBox["b)",
    FontWeight->"Bold"],
  "  ",
  Cell[BoxData[
      \(TraditionalForm\`y = \(-x\^2\) - 2  x\)]],
  "  e  ",
  Cell[BoxData[
      \(TraditionalForm\`y = x\^2 - 4\)]],
  ", para  ",
  Cell[BoxData[
      \(TraditionalForm\`\(-3\) \[LessEqual] \ \ x \[LessEqual] \ 1\)]],
  ".\n",
  StyleBox["c)",
    FontWeight->"Bold"],
  "  ",
  Cell[BoxData[
      \(TraditionalForm\`y = x\^2\)]],
  "  y   ",
  Cell[BoxData[
      \(TraditionalForm\`x + y = 2\)]],
  ", con ",
  Cell[BoxData[
      \(TraditionalForm\`x \[GreaterEqual] \ 0, \ y \[GreaterEqual] \ 0\)]],
  ".\n",
  StyleBox["d)",
    FontWeight->"Bold"],
  "  ",
  Cell[BoxData[
      \(TraditionalForm\`x + y\^2 = 3\)]],
  "  y  ",
  Cell[BoxData[
      \(TraditionalForm\`4  x + y\^2 = 4\)]],
  ".\n",
  StyleBox["e)",
    FontWeight->"Bold"],
  "  ",
  Cell[BoxData[
      \(TraditionalForm\`y = \(sec\^2\) x, \ \ y = \(tg\^2\) x, \ 
      \(-\[Pi]\)/4 \[LessEqual] \ x \[LessEqual] \ \[Pi]/4\)]],
  ".\n",
  StyleBox["f)",
    FontWeight->"Bold"],
  "  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(x\^2\/4 + y\^2\/9\),
            FontSize->18], "=", "1"}], TraditionalForm]]],
  ".\n",
  StyleBox["g)",
    FontWeight->"Bold"],
  "  ",
  Cell[BoxData[
      \(TraditionalForm\`\((y - x)\)\^2 = x - 3\)]],
  ",  y  ",
  Cell[BoxData[
      \(TraditionalForm\`x = 7\)]],
  ".\n",
  StyleBox["h)  ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`y = x\^4 + x\^3 + 16  x - 4\)]],
  "  y  ",
  Cell[BoxData[
      \(TraditionalForm\`y = x\^4 + 6  x\^2 + 8  x - 4\)]],
  ". \n",
  StyleBox["i)",
    FontWeight->"Bold"],
  "  ",
  Cell[BoxData[
      FormBox[
        RowBox[{"y", "=", 
          StyleBox[\(\(4\ x\^3\)\/\@\(x\^4 - \ x\^2 + 1\)\),
            FontSize->18]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{"y", "=", 
          StyleBox[\(\(2\ x\)\/\@\(x\^4 - x\^2 + 1\)\),
            FontSize->18]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] \ x \[LessEqual] \ 1\)]],
  ".\n",
  StyleBox["j)  ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`y = \((log\ x)\)\^2, \ 0 < \ x \[LessEqual] \ e\)]],
  ".\n",
  StyleBox["k)",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(y\^2\), "=", 
          StyleBox[\(\(1 - \ x\)\/\(1 + \ x\)\),
            FontSize->18]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`x = \(-1\)\)]],
  ".\n",
  StyleBox["l)",
    FontWeight->"Bold"],
  "  ",
  Cell[BoxData[
      \(TraditionalForm\`y = x\ e\^\(-x\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`y = \(x\^2\) e\^\(-x\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`x \[GreaterEqual] \ 0\)]],
  "."
}], "Text"],

Cell[TextData[{
  StyleBox["2",
    FontWeight->"Bold"],
  " Calcula el \[AAcute]rea de la regi\[OAcute]n limitada por la astroide ",
  Cell[BoxData[
      \(TraditionalForm\`\@\(x\^2\)\%3 + \@\(y\^2\)\%3 = 1\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(\(\(tipo1[{\@\((1 - \@\(x\^2\)\%3)\)\^3, \(-\@\((1 - \
\@\(x\^2\)\%3)\)\^3\)}, {x, \(-1\), 1}, AspectRatio -> 1];\)\(\ \)\( (*\ 
      representa\ la\ astroide\ *) \)\)\)], "Input"],

Cell[TextData[{
  StyleBox["3",
    FontWeight->"Bold"],
  " Calcula el \[AAcute]rea de la regi\[OAcute]n comprendida entre la cisoide \
",
  Cell[BoxData[
      FormBox[
        RowBox[{\(y\^2\), "=", 
          StyleBox[\(x\^3\/\(2\  - \ x\)\),
            FontSize->18]}], TraditionalForm]]],
  " y su as\[IAcute]ntota ",
  Cell[BoxData[
      \(TraditionalForm\`x = 2. \)]]
}], "Text"],

Cell[BoxData[
    \(\(\(tipo1[{\@\(x\^3\/\(2 - x\)\), \(-\@\(x\^3\/\(2 - x\)\)\)}, {x, 0, 
        1.3}, Ticks \[Rule] None, 
      AspectRatio \[Rule] Automatic]\)\(;\)\(\ \)\( (*\ 
      representa\ parte\ de\ la\ cisoide\ sin\ llegar\ a\ la\ \
as\[IAcute]ntota\ vertical\ en\ x = 2\ *) \)\)\)], "Input"],

Cell[TextData[{
  StyleBox["4",
    FontWeight->"Bold"],
  " Calcula el \[AAcute]rea de las dos partes en que la par\[AAcute]bola ",
  Cell[BoxData[
      \(TraditionalForm\`y\^2 = x\)]],
  " divide al c\[IAcute]rculo ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 = 8\)]],
  "."
}], "Text"],

Cell[BoxData[{
    \(\({a, b} = y /. Solve[y\^2 == \@\(8 - y\^2\), y];\)\), "\n", 
    \(\(tipo2[{y\^2, \@\(8 - y\^2\)}, {y, a, b}, AxesFront \[Rule] True, 
        AspectRatio \[Rule] Automatic];\)\), "\n", 
    \(Clear[a, b]\)}], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Curvas definidas por ecuaciones param\[EAcute]tricas", "Section"],

Cell[TextData[{
  "Seguramente te imaginas una curva en el plano como una l\[IAcute]nea \
continua que puede dibujarse de un trazo, sin levantar el l\[AAcute]piz del \
papel. Esa idea es esencialmente correcta. Las circunferencias, las elipses, \
las astroides son todas ellas curvas. Faltar\[IAcute]a m\[AAcute]s. Ninguna \
de ellas puedes representarla por una igualdad de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`y = f \((x)\)\)]],
  ". Las curvas que pueden representarse por una ecuaci\[OAcute]n cartesiana \
del tipo ",
  Cell[BoxData[
      \(TraditionalForm\`y = f \((x)\)\)]],
  " son curvas muy particulares pues son gr\[AAcute]ficas de funciones. No \
olvides que cuando dices \"sea la curva dada por la ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`y = f \((x)\)\)]],
  "\"  te est\[AAcute]s refiriendo a la curva cuya imagen es el conjunto de \
puntos del plano ",
  Cell[BoxData[
      \(TraditionalForm
      \`{\((x, y)\) : x\ \[Epsilon]\ [a, b], \ y = f(x)}\)]],
  ", es decir, a la gr\[AAcute]fica de ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  ". Si lo piensas un momento ver\[AAcute]s que muy pocas curvas son gr\
\[AAcute]ficas. Para que una curva sea una gr\[AAcute]fica es necesario que \
cualquier recta vertical la corte a lo m\[AAcute]s en un solo punto; ninguna \
curva cerrada cumple esta condici\[OAcute]n. Precisamente entre las curvas \
cerradas se encuentran algunas de las curvas m\[AAcute]s intersantes, a ellas \
pertenecen los distintos tipos de \[OAcute]valos y lemniscatas, las \
cardioides, y muchas m\[AAcute]s. Vamos a ver ahora una forma de representar \
curvas planas mucho m\[AAcute]s general que las ecuaciones cartesianas del \
tipo ",
  Cell[BoxData[
      \(TraditionalForm\`y = f \((x)\)\)]],
  " que s\[OAcute]lo sirven para representar curvas que tambi\[EAcute]n son \
gr\[AAcute]ficas.\nPara empezar, consideremos una curva que viene dada por \
una ecuaci\[OAcute]n cartesiana de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`y = f \((x)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`a \[LessEqual] \ x \[LessEqual] \ y\)]],
  ". Nuestra curva es, por tanto, la imagen de la aplicaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma] : \([a, b]\)\  \[Rule] \ \[DoubleStruckCapitalR]\^2\)]],
  " definida por ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](x) = \((x, f(x))\)\)]],
  " para todo ",
  Cell[BoxData[
      \(TraditionalForm\`x\ \[Epsilon]\ [a, b]\)]],
  ". Intuitavamente, cuando  ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "  recorre el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([a, b]\)\)]],
  ", el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, f \((x)\))\)\)]],
  " recorre la curva. Es f\[AAcute]cil generalizar esta situaci\[OAcute]n sin \
perder la idea intuitiva de curva. Lo esencial es que podamos describir las \
coordendas de los puntos de la curva como funciones continuas de un par\
\[AAcute]metro. En la situaci\[OAcute]n que estamos considerando se tiene que \
",
  Cell[BoxData[
      \(TraditionalForm\`y = f \((x)\)\)]],
  " ,es decir, la segunda coordenada es funci\[OAcute]n continua de la \
primera. La generalizaci\[OAcute]n consiste en que ambas coordenadas sean \
funciones continuas de un par\[AAcute]metro. Llegamos as\[IAcute] a la \
definici\[OAcute]n siguiente.\n",
  StyleBox["Definici\[OAcute]n",
    FontWeight->"Bold"],
  ". Una curva en el plano es una aplicaci\[OAcute]n continua ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma] : \([a, b]\)\  \[Rule] \ \[DoubleStruckCapitalR]\^2\)]],
  ". Si ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((x(t), y(t))\)\)]],
  " decimos que ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{"{", GridBox[{
                {\(x = x(t)\)},
                {\(y = y(t)\)}
                }]}]}], TraditionalForm]]],
  "  son las ",
  StyleBox["ecuaciones par\[AAcute]metricas",
    FontWeight->"Bold"],
  " de la curva. El punto \[Gamma](a) es el origen y \[Gamma](b) el extremo \
de la curva. Si ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](a) = \[Gamma](b)\)]],
  " se dice que la curva es ",
  StyleBox["cerrada",
    FontWeight->"Bold"],
  ". Se dice que una curva \[Gamma] es ",
  StyleBox["simple",
    FontWeight->"Bold"],
  " si no se corta a s\[IAcute] misma, es decir, si para ",
  Cell[BoxData[
      \(TraditionalForm\`\(s, t\ \[Epsilon]\ [a, b]\ \)\)]],
  "con  ",
  Cell[BoxData[
      \(TraditionalForm\`t \[NotEqual] s\)]],
  "  se verifica que  ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) \[NotEqual] \[Gamma](s)\)]],
  ". Una curva cerrada se llama simple si la funci\[OAcute]n \[Gamma] es \
inyectiva en ]a,b[."
}], "Text"],

Cell[CellGroupData[{

Cell[" Ejemplos", "Subsubsection"],

Cell[TextData[{
  "\[FilledSmallCircle]  La curva de ecuaciones param\[EAcute]tricas ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          StyleBox[\(x = \[Alpha] + a\ cos\ t, y = \[Beta] + b\ sen\ t\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] \ 2  \[Pi], \ 
      \[Alpha] > 0, \[Beta] > 0\)]],
  " es una ",
  StyleBox["elipse",
    FontWeight->"Bold"],
  " de centro ",
  Cell[BoxData[
      \(TraditionalForm\`\((\[Alpha], \[Beta])\)\)]],
  " y semiejes de longitudes ",
  Cell[BoxData[
      \(TraditionalForm\`a, \ b\)]],
  ". Cuando ",
  Cell[BoxData[
      \(TraditionalForm\`a = b\)]],
  " se trata de una c\[IAcute]rcunferencia."
}], "Text"],

Cell[BoxData[
    \(\(ParametricPlot[{1 + 3  Cos[t], 1 + 2  Sin[t]}, {t, 0, 
          2  \[Pi]}];\)\)], "Input"],

Cell[TextData[{
  "\[FilledSmallCircle]  La curva de ecuaciones param\[EAcute]tricas  ",
  Cell[BoxData[
      \(TraditionalForm\`x = r\ \((t - sen\ t)\), \ 
      y = r\ \((1 - \ cos\ t)\)\)]],
  " para ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          FormBox[\(0 \[LessEqual] t \[LessEqual] \ 2  \[Pi]\),
            "TraditionalForm"], " "}], TraditionalForm]]],
  "es la ",
  StyleBox["cicloide",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ". Es la curva que describir\[IAcute]a una chincheta clavada en una rueda \
de radio ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " que avanza girando sin deslizar. "
}], "Text"],

Cell[BoxData[
    \(\(ParametricPlot[{t - Sin[t], \ 1 - Cos[t]}, {t, 0, 2  \[Pi]}, 
      AspectRatio \[Rule] Automatic, 
      Ticks \[Rule] {{\[Pi], 2  \[Pi]}, {1, 2}}]; \)\)], "Input"],

Cell["\<\
Para ver c\[OAcute]mo se genera la cicloide ejecuta la siguiente celda\
\>", "Text"],

Cell[BoxData[{
    \(\(cicloide;\)\), "\n", 
    \(\(SelectionMove[EvaluationNotebook[], All, GeneratedCell];\)\), "\n", 
    \(FrontEndTokenExecute["\<CellGroup\>"]\), "\n", 
    \(FrontEndTokenExecute["\<OpenCloseGroup\>"]\)}], "Input"],

Cell[TextData[{
  "\[FilledSmallCircle]  La curva de ecuaciones param\[EAcute]tricas  ",
  Cell[BoxData[
      \(TraditionalForm\`x = cos\ t\ \((1 + cos\ t)\), \ 
      y = sen\ t\ \((1 + cos\ t)\)\)]],
  " para ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          FormBox[\(0 \[LessEqual] t \[LessEqual] \ 2  \[Pi]\),
            "TraditionalForm"], " "}], TraditionalForm]]],
  "es una ",
  StyleBox["cardioide",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ". Es la curva que describe un punto fijo del borde de un c\[IAcute]rculo \
que rueda sin deslizar sobre otro del mismo radio. "
}], "Text"],

Cell[BoxData[
    \(\(ParametricPlot[{\((Cos[t] + 1)\)\ Cos[t], \((Cos[t] + 1)\)\ Sin[t]}, {
        t, 0, 2\ \[Pi]}, AspectRatio \[Rule] Automatic]; \)\)], "Input"],

Cell[TextData[{
  "La ecuaci\[OAcute]n cartesiana de la cardioide es ",
  Cell[BoxData[
      FormBox[
        FormBox[
          \(\((x\^2 - 2\ a\ x + y\^2)\)\^2 = \((x\^2 + y\^2)\)\ 4\ a\^2\),
          "TraditionalForm"], TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " es un par\[AAcute]metro positivo. Para ver c\[OAcute]mo se genera la \
cardiode ejecuta la siguiente celda"
}], "Text"],

Cell[BoxData[{
    \(\(cardioide;\)\), "\n", 
    \(\(SelectionMove[EvaluationNotebook[], All, GeneratedCell];\)\), "\n", 
    \(FrontEndTokenExecute["\<CellGroup\>"]\), "\n", 
    \(FrontEndTokenExecute["\<OpenCloseGroup\>"]\)}], "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"\[FilledSmallCircle]", "  ", "La", " ", 
            StyleBox["lemniscata",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox[" ",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox["de",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox[" ",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox["Bernouilli",
              FontWeight->"Bold",
              FontSlant->"Italic"], " ", "es", " ", "la", " ", "curva", " ", 
            "de", " ", "ecuaciones", " ", "param\[EAcute]tricas", 
            StyleBox["  ",
              FontFamily->"Times New Roman",
              FontSize->13], 
            StyleBox["x",
              FontFamily->"Times New Roman"], 
            StyleBox[\((t)\),
              FontFamily->"Times New Roman"]}], 
          StyleBox["=",
            FontFamily->"Times New Roman"], 
          StyleBox[\(\(cos \((t)\)\)\/\(\(sen\^2\) \((t)\) + 1\)\),
            FontFamily->"Times New Roman"]}], 
        StyleBox[" ",
          FontFamily->"Times New Roman"], 
        StyleBox[",",
          FontFamily->"Times New Roman"], 
        StyleBox[" ",
          FontFamily->"Times New Roman"], 
        RowBox[{
          StyleBox[\(y \((t)\)\),
            FontFamily->"Times New Roman"], 
          StyleBox["=",
            FontFamily->"Times New Roman"], 
          RowBox[{
            
            StyleBox[
              \(\(cos \((t)\) sen \((t)\)\)\/\(\(sen\^2\) \((t)\) + 1\)\),
              FontFamily->"Times New Roman"], " ", "para", 
            RowBox[{
              FormBox[
                RowBox[{" ", 
                  FormBox[\(0 \[LessEqual] t \[LessEqual] \ 2  \[Pi]\),
                    "TraditionalForm"], " "}],
                "TraditionalForm"], "."}]}]}]}], TextForm]], "Text"],

Cell[BoxData[
    \(\(ParametricPlot[{Cos[t]\/\(Sin[t]\^2 + 1\), 
        \(Sin[t]\ Cos[t]\)\/\(Sin[t]\^2 + 1\)}, {t, 0, \ 2  \[Pi]}, 
      AspectRatio \[Rule] Automatic, ImageSize \[Rule] {417, 147.375}]; 
    \)\)], "Input"],

Cell[TextData[{
  "La ecuaci\[OAcute]n cartesiana de la lemniscata es  ",
  Cell[BoxData[
      \(TraditionalForm\`\((x\^2 + y\^2)\)\^2 = x\^2 - y\^2\)]],
  " y se define como el lugar geom\[EAcute]trico de los puntos del plano cuyo \
producto de distancias a dos puntos fijos es constante igual al cuadrado de \
la semidistancia entre dichos puntos. Observa que, a diferencia de las \
anteriores, la lemniscata no es una curva simple."
}], "Text"],

Cell[TextData[
"\[FilledSmallCircle]  Aqu\[IAcute] tienes otro ejemplo de una curva que no \
es simple. "], "Text"],

Cell[BoxData[
    \(\(ParametricPlot[{Cos[3  x], Sin[5  x]}, {x, 0, 2  \[Pi]}, 
      AspectRatio \[Rule] Automatic, 
      PlotStyle -> {Thickness[ .008], Hue[ .65]}, Ticks -> None]; \)\)], 
  "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  " ",
  StyleBox[
  "C\[AAcute]lculo del \[AAcute]rea de una regi\[OAcute]n plana rodeada por \
una curva definida por ecuaciones param\[EAcute]tricas",
    FontSize->16]
}], "Subsubsection",
  FontSize->12],

Cell[TextData[{
  "Sea \[CapitalOmega] la regi\[OAcute]n rodeada por una curva ",
  StyleBox["cerrada simple",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((x(t), y(t))\), \ 
      \((a \[LessEqual] t \[LessEqual] b)\)\)]],
  " y supongamos que las funciones ",
  Cell[BoxData[
      \(TraditionalForm\`t \[RightArrow] \ x(t), \ 
      t \[RightArrow] \ y(t)\)]],
  " tienen primera derivada continua. Supongamos tambi\[EAcute]n que si, a \
medida que el par\[AAcute]metro ",
  StyleBox["t",
    FontSlant->"Italic"],
  " recorre el intervalo desde",
  Cell[BoxData[
      \(TraditionalForm\`\(\ t = a\)\)]],
  " hasta ",
  Cell[BoxData[
      \(TraditionalForm\`t = b\)]],
  ", andamos sobre la curva siguiendo al punto ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t)\)]],
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox["la regi\[OAcute]n \[CapitalOmega] queda a nuestar izquierda",
    FontWeight->"Bold"],
  ". En estas condiciones se verifica que el \[AAcute]rea de \[CapitalOmega] \
viene dada por:"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{"  ", 
        RowBox[{
          FormBox[
            RowBox[{
              RowBox[{\(\[Lambda](\[CapitalOmega])\), "=", 
                RowBox[{
                  RowBox[{
                    StyleBox[\(\[Integral]\_a\%b\),
                      FontSize->16], 
                    RowBox[{
                      RowBox[{
                        StyleBox["x",
                          FontSize->16], "(", "t", ")"}], \(y'\), \((t)\), 
                      \(\[DifferentialD]t\)}]}], " ", "=", 
                  RowBox[{
                    RowBox[{"-", 
                      RowBox[{
                        StyleBox[\(\[Integral]\_a\%b\),
                          FontSize->16], 
                        RowBox[{
                          RowBox[{
                            StyleBox["y",
                              FontSize->16], "(", "t", ")"}], \(x'\), 
                          \((t)\), \(\[DifferentialD]t\)}]}]}], "=", 
                    \(1\/2\)}]}]}], " "}],
            "TraditionalForm"], 
          RowBox[{
            StyleBox[\(\[Integral]\_a\%b\),
              FontSize->16], 
            RowBox[{
              RowBox[{
                StyleBox["(",
                  FontSize->16], 
                RowBox[{
                  RowBox[{
                    RowBox[{
                      StyleBox["x",
                        FontSize->16], "(", "t", ")"}], \(y'\), \((t)\)}], 
                  "-", " ", \(\(y(t)\) x' \((t)\)\)}], 
                StyleBox[")",
                  FontSize->14]}], \(\[DifferentialD]t\)}]}]}]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "La igualdad entre las dos integrales se deduce f\[AAcute]cilmente \
integrando por partes y teniendo en cuenta que por ser ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\)]],
  " una curva cerrada se tiene que  ",
  Cell[BoxData[
      \(TraditionalForm\`\(x(b)\) \(y(b)\) - \(x(a)\) \(y(a)\) = 0\)]],
  ". Si el sentido de recorrido de la curva es el opuesto al anterior de \
forma que al recorrerla la regi\[OAcute]n \[CapitalOmega] queda a la derecha \
debemos cambiar el signo en las integrales anteriores."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[" Ejemplos", "Subsubsection"],

Cell[BoxData[
    FormBox[
      RowBox[{"\[FilledSmallCircle]", 
        StyleBox["  ",
          FontWeight->"Plain"], 
        StyleBox["\[CapitalAAcute]rea",
          FontWeight->"Plain"], 
        StyleBox[" ",
          FontWeight->"Plain"], 
        StyleBox["de",
          FontWeight->"Plain"], 
        StyleBox[" ",
          FontWeight->"Plain"], 
        StyleBox["la",
          FontWeight->"Plain"], 
        StyleBox[" ",
          FontWeight->"Plain"], 
        StyleBox["regi\[OAcute]n",
          FontWeight->"Plain"], 
        StyleBox["  ",
          FontWeight->"Plain"], 
        StyleBox["\[CapitalOmega]",
          FontWeight->"Plain"], 
        StyleBox[" ",
          FontWeight->"Plain"], 
        StyleBox["encerrada",
          FontWeight->"Plain"], 
        StyleBox[" ",
          FontWeight->"Plain"], 
        StyleBox["por",
          FontWeight->"Plain"], 
        StyleBox[" ",
          FontWeight->"Plain"], 
        StyleBox["la",
          FontWeight->"Plain"], 
        StyleBox[" ",
          FontWeight->"Plain"], 
        StyleBox["elipse",
          FontWeight->"Plain"], 
        StyleBox[" ",
          FontWeight->"Plain"], 
        FormBox[\(\ x(t) = \[Alpha]\  + a\ cos\ t, \ 
          y(t) = \[Beta] + \ b\ sen\ t\),
          "TraditionalForm"], 
        StyleBox["  ",
          FontWeight->"Plain"], 
        RowBox[{
          FormBox[
            StyleBox[\((0 \[LessEqual] t \[LessEqual] 2 \[Pi])\),
              FontWeight->"Plain"],
            "TraditionalForm"], "."}]}], TextForm]], "Text"],

Cell[TextData[
" Observa que al recorrer la curva la regi\[OAcute]n \[CapitalOmega] queda a \
la izquierda por lo que el \[AAcute]rea viene dada por:"], "Text"],

Cell[BoxData[
    \(x[t_] = \[Alpha] + a\ Cos[t]; \ny[t_] = \[Beta]\  + \ b\ Sin[t]; \n
    Integrate[x[t] \(y'\)[t], {t, 0, 2  Pi}]\)], "Input"],

Cell[TextData[{
  "\[FilledSmallCircle]",
  StyleBox[
  "  Calcular el \[AAcute]rea de la regi\[OAcute]n \[CapitalOmega] encerrada \
por un arco de la cicloide  ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{"  ", 
          
          FormBox[\(x(t) = r\ \((t - sen\ t)\), \ 
            y(t) = r\ \((1 - \ cos\ t)\)\),
            "TraditionalForm"]}], TraditionalForm]],
    FontWeight->"Plain"],
  ", ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(0 \[LessEqual] t \[LessEqual] 2 \[Pi]\),
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox[", y el segmento que va de ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\((2  \[Pi]\ r, 0)\)\)],
    FontWeight->"Plain"],
  StyleBox[" a (0,0). Dicho segmento tiene como ecuaciones parametricas ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\((u(t), v(t))\) = \((\ \(-r\)\ t\  + 4 \[Pi]\ r, 0)\)\),
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["donde ",
    FontWeight->"Plain"],
  " ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(2 \[Pi] \[LessEqual] t \[LessEqual] 4 \[Pi]\),
          FontWeight->"Plain"], TraditionalForm]]],
  ". "
}], "Text",
  FontWeight->"Bold"],

Cell[TextData[StyleBox[
"Observa que al recorrer la curva la regi\[OAcute]n \[CapitalOmega] queda a \
la derecha por lo que el \[AAcute]rea viene dada por:",
  FontWeight->"Plain"]], "Text"],

Cell[BoxData[
    \(x[t_] = r \((t - Sin[t])\); \ny[t_] = r \((1 - Cos[t])\); \n
    u[t_] = \(-\ r\)\ t + 4\ Pi\ r; \nv[t_] = 0; \n
    \(-Integrate[x[t] \(y'\)[t], {t, 0, 2  Pi}]\) - 
      Integrate[u[t] \(v'\)[t], {t, 2  Pi, 4  Pi}]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["  Ejercicios", "Subsection"],

Cell[TextData[{
  "5",
  StyleBox[" Calcular el \[AAcute]rea encerrada por la cardioide  ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(x = cos\ t\ \((1 + cos\ t)\)\),
            FontWeight->"Plain"], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          RowBox[{
            StyleBox["y",
              FontWeight->"Plain"], 
            StyleBox["=",
              FontWeight->"Plain"], 
            RowBox[{
              StyleBox["sen",
                FontWeight->"Plain"], 
              StyleBox[" ",
                FontWeight->"Plain"], 
              StyleBox["t",
                FontWeight->"Plain"], 
              StyleBox[" ",
                FontWeight->"Plain"], 
              RowBox[{"(", 
                StyleBox[\(1 + cos\ t\),
                  FontWeight->"Plain"], 
                StyleBox[")",
                  FontWeight->"Plain"]}]}]}], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox[\(0 \[LessEqual] t \[LessEqual] \ 2 \[Pi]\),
            FontWeight->"Plain"]}], TraditionalForm]]],
  ". "
}], "Text",
  FontWeight->"Bold"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\[CapitalAAcute]reas planas en coordenadas polares ", "Section"],

Cell[TextData[{
  "Dado un punto ",
  Cell[BoxData[
      \(TraditionalForm
      \`\((x, y)\)\ \[Epsilon]\ \[DoubleStruckCapitalR]\^2\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(\((x, y)\) \[NotEqual] \ \((0, 0)\), \)\)]],
  " hay un \[UAcute]nico par de n\[UAcute]meros ",
  Cell[BoxData[
      \(TraditionalForm\`\((\[Rho], \[Theta])\)\)]],
  " tales que ",
  Cell[BoxData[
      \(TraditionalForm\`0 < \[Rho]\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\) < \[Theta] \[LessEqual] \[Pi]\)]],
  " y que verifican las igualdades ",
  Cell[BoxData[
      FormBox[
        TagBox[
          RowBox[{"{", GridBox[{
                {\(x = \[Rho]\ cos\ \[Theta]\)},
                {\(y = \ \[Rho]\ sen\ \[Theta]\)}
                }]}],
          (#&)], TraditionalForm]]],
  ". Dichos n\[UAcute]meros se llaman ",
  StyleBox["coordenadas polares",
    FontSlant->"Italic"],
  " del punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  " y vienen dados por ",
  Cell[BoxData[
      FormBox[
        TagBox["",
          (#&)], TraditionalForm]]],
  Cell[BoxData[
      \(TraditionalForm\`\[Rho] = \@\(x\^2 + y\^2\)\)]],
  ";  ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Theta]", "=", 
          RowBox[{"arctg", 
            StyleBox[\(y\/\(x\ \)\),
              FontSize->18]}]}], TraditionalForm]]],
  "si ",
  Cell[BoxData[
      \(TraditionalForm\`x > 0\)]],
  ";",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{"\[Theta]", "=", 
            FormBox[
              RowBox[{
                RowBox[{"arctg", 
                  StyleBox[\(y\/\(x\ \)\),
                    FontSize->18]}], 
                StyleBox["-",
                  FontSize->18], 
                StyleBox["\[Pi]",
                  FontSize->14]}],
              "TraditionalForm"]}]}], TraditionalForm]]],
  " si ",
  Cell[BoxData[
      \(TraditionalForm\`x < 0, \ y < 0\)]],
  "; ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Theta]", "=", 
          FormBox[
            RowBox[{
              RowBox[{"arctg", 
                StyleBox[\(y\/\(x\ \)\),
                  FontSize->18]}], "+", 
              StyleBox["\[Pi]",
                FontSize->14]}],
            "TraditionalForm"]}], TraditionalForm]]],
  " si ",
  Cell[BoxData[
      \(TraditionalForm\`x < 0, \ y \[GreaterEqual] 0\)]],
  "; ",
  Cell[BoxData[
      \(TraditionalForm\`\[Theta] = \[Pi]/2\)]],
  " si ",
  Cell[BoxData[
      \(TraditionalForm\`x = 0, \ y > 0\)]],
  "; ",
  Cell[BoxData[
      \(TraditionalForm\`\[Theta] = \(-\[Pi]\)/2\)]],
  " si ",
  Cell[BoxData[
      \(TraditionalForm\`x = 0, \ y < 0\)]],
  ". El n\[UAcute]mero \[Theta] se llama ",
  StyleBox["\[AAcute]ngulo polar",
    FontSlant->"Italic"],
  " del vector ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  " y el n\[UAcute]mero \[Rho] es la norma eucl\[IAcute]dea de dicho vector. \
La funci\[OAcute]n \"polares[{x,y}]\" proporciona las coordenadas polares del \
punto de coordenadas cartesianas ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  ". La funci\[OAcute]n \"cartesianas[{\[Rho],\[Theta]}]\" proporciona las \
coordenadas cartesianas del punto de coordenadas polares ",
  Cell[BoxData[
      \(TraditionalForm\`\((\[Rho], \[Theta])\)\)]],
  ".  Practica un poco con estos comandos y observa c\[OAcute]mo la funci\
\[OAcute]n \"ArcTan[x,y]\" tiene en cuenta el cuadrante donde est\[AAcute] el \
punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(polares[{x_, y_}] := {\@\(x\^2 + y\^2\), ArcTan[x, y]}; \n
    cartesianas[{\[Rho]_, \[Theta]_}] := {\[Rho]\ Cos[\[Theta]], 
        \[Rho]\ Sin[\[Theta]]}; \)], "Input"],

Cell[TextData[{
  "Es importante advertir que en la definici\[OAcute]n anterior el intervalo \
]",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\), \[Pi]\)]],
  "]  se puede sustituir por cualquier intervalo ",
  StyleBox["semiabierto",
    FontSlant->"Italic"],
  " ",
  StyleBox["I",
    FontSlant->"Italic"],
  " de longitud 2\[Pi] lo que, naturalmente, implica modificar la definici\
\[OAcute]n de \[Theta] sumando o restando, seg\[UAcute]n proceda, un m\
\[UAcute]ltiplo conveniente de 2\[Pi] de manera que el \[AAcute]ngulo polar \
est\[EAcute] en dicho intervalo ",
  StyleBox["I",
    FontSlant->"Italic"],
  ". Es frecuente considerar valores del \[AAcute]ngulo polar en el intervalo \
[",
  Cell[BoxData[
      \(TraditionalForm\`0, 2  \[Pi]\)]],
  "[.  Salvo que se especifique otra cosa, entenderemos que el \[AAcute]ngulo \
polar est\[AAcute] en el intervalo  ]",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\), \[Pi]\)]],
  "].\nLa funci\[OAcute]n \"PolarPlot[f[\[Theta]],{\[Theta], \[Alpha], \
\[Beta]}]\" representa la curva cuya ecuaci\[OAcute]n en coordenadas polares \
es ",
  Cell[BoxData[
      \(TraditionalForm\`\[Rho] = f(\[Theta]), \ \ 
      \((\[Alpha] \[LessEqual] \[Theta] \[LessEqual] \[Beta])\)\)]],
  ". Es decir, representa el conjunto de puntos del plano cuyas coordenadas \
polares son  ",
  Cell[BoxData[
      \(TraditionalForm\`\((f(\[Theta]), \[Theta])\)\)]],
  " cuando ",
  Cell[BoxData[
      \(TraditionalForm\`\[Theta]\ \[Epsilon]\ [\[Alpha], \[Beta]]\)]],
  ". Equivalentemente, ",
  StyleBox["se trata de la curva cuyas ecuaciones param\[EAcute]tricas son",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`x(\[Theta]) = \(f(\[Theta])\) \(cos(\[Theta])\), \ 
      y(\[Theta]) = \(f(\[Theta])\) sen\ \((\[Theta])\)\)]],
  ",  ",
  Cell[BoxData[
      \(TraditionalForm\`\[Theta]\ \[Epsilon]\ [\[Alpha], \[Beta]]\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(\(\(\(PolarPlot[1 + Cos[\[Theta]], {\[Theta], 0, 2  \[Pi]}, 
        AspectRatio \[Rule] Automatic];\)\(\ \)\)\( (*\ 
      la\ cardioide, \ \((x\^2 - x + y\^2)\)\^2 - \((x\^2 + y\^2)\) = 0, \ 
      cuya\ ecuaci\[OAcute]n\ en\ coordenadas\ polares\ es\ \[Rho] = 
        1 + Cos[\[Theta]]\ *) \)\)\)], "Input"],

Cell[BoxData[
    RowBox[{
    \(PolarPlot[\@Cos[2\ \[Theta]], {\[Theta], \(-\[Pi]\)/4, \[Pi]/4}, 
        AspectRatio \[Rule] Automatic]; \), " ", 
      RowBox[{"(*", " ", 
        RowBox[{
          RowBox[{"la", " ", 
            StyleBox["mitad",
              FontSlant->"Italic"], " ", "de", " ", "la", " ", 
            "lemniscata"}], ",", " ", 
          RowBox[{
            FormBox[\(\((x\^2 + y\^2)\)\^2 - x\^2 + y\^2\),
              "TraditionalForm"], "=", "0"}], ",", " ", 
          \(cuya\ ecuaci\[OAcute]n\ en\ coordenadas\ polares\ es\ \[Rho]\^2 = 
            Cos[2  \[Theta]]\)}], " ", "*)"}]}]], "Input"],

Cell[BoxData[
    \(\(\(\(PolarPlot[\[Theta], {\[Theta], 0, 4  \[Pi]}, 
        AspectRatio \[Rule] Automatic]; \)\ \) (*\ 
      las\ dos\ primeros\ vueltas\ de\ la\ espiral\ de\ Arqu\[IAcute]mides\ 
          cuya\ ecuaci\[OAcute]n\ en\ coordenadas\ polares\ es\ \[Rho] = 
        \[Theta]\ *) \)\)], "Input"],

Cell[TextData[{
  "Supongamos que queremos calcular el \[AAcute]rea de la regi\[OAcute]n del \
plano ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[CapitalOmega] = {
          \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \[Theta])\) : \ 
            0 \[LessEqual] \[Rho] \[LessEqual] f(\[Theta]), \ 
          \[Alpha] \[LessEqual] \[Theta] \[LessEqual] \[Beta]}\)]],
  ". Se trata de la regi\[OAcute]n limitada por la gr\[AAcute]fica de la \
curva dada en coordenadas polares por la ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\[Rho] = f(\[Theta])\)]],
  ", donde ",
  Cell[BoxData[
      \(TraditionalForm
      \`f : \([\[Alpha], \[Beta]]
            \)\[LongRightArrow]\[DoubleStruckCapitalR]\)]],
  " es una funci\[OAcute]n continua, y las rectas cuya ecuaci\[OAcute]n en \
coordendas polares son ",
  Cell[BoxData[
      \(TraditionalForm\`\[Theta] = \[Alpha], \ \[Theta] = \[Beta]\)]],
  ". F\[IAcute]jate en la figura. "
}], "Text"],

Cell[BoxData[
    \(\(fig;\)\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  "Lo que hacemos para calcular el \[AAcute]rea es aproximar \[CapitalOmega] \
por medio de sectores circulares. Recuerda que el \[AAcute]rea de un sector \
circular de radio \[Rho] y amplitud \[CurlyPhi] (medida en radianes) es igual \
a ",
  Cell[BoxData[
      RowBox[{
        FormBox[\(\(1\/2\) \(\[Rho]\^2\) \(\[CurlyPhi] . \)\),
          "TraditionalForm"], " "}]]],
  "Consideramos para ello una partici\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          \(\[Alpha] = 
            \(\(\[Theta]\_0 < \[Theta]\_1 < \[Theta]\_2 < \  ... \)\  < 
                \[Theta]\_\(n - 1\) < \[Theta]\_n = \[Beta]\)\),
          FontSize->12], TraditionalForm]],
    FontSize->16],
  " de",
  StyleBox[" ",
    FontSize->16],
  Cell[BoxData[
      FormBox[
        StyleBox[\([\[Alpha], \[Beta]]\),
          FontSize->12], TraditionalForm]],
    FontSize->16],
  " y formamos la suma ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Sum]\+\(k = 1\)\%n\( 1\/2\) \(\((f(\[Theta]\_k))\)\^2\) 
          \((\[Theta]\_k - \[Theta]\_\(k - 1\))\)\)]],
  ". Como el n\[UAcute]mero ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(1\/2\) \(\((f(\[Theta]\_k))\)\^2\) 
        \((\[Theta]\_k - \[Theta]\_\(k - 1\))\)\)]],
  " es el \[AAcute]rea del sector circular, representado en azul en la \
figura, de radio ",
  Cell[BoxData[
      \(TraditionalForm\`\(f(\[Theta]\_k)\ \)\)]],
  "y amplitud  igual a ",
  Cell[BoxData[
      \(TraditionalForm\`\[Theta]\_k - \[Theta]\_\(k - 1\)\)]],
  ", es claro que la suma anterior representa una aproximaci\[OAcute]n del \
\[AAcute]rea de \[CapitalOmega]. Como ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Sum]\+\(k = 1\)\%n\( 1\/2\) \(\((f(\[Theta]\_k))\)\^2\) 
          \((\[Theta]\_k - \[Theta]\_\(k - 1\))\)\)]],
  " es una suma de Riemann de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Theta]\ \[LongRightArrow]\ \(1\/2\) \(f(\[Theta])\)\^2\)]],
  ", se sigue que el \[AAcute]rea de \[CapitalOmega] viene dada por "
}], "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`\[Lambda](\[CapitalOmega]) = 
      \(1\/2\) \(\[Integral]\_\[Alpha]\%\[Beta]\(\((f(\[Theta]))\)\^2\) 
            \[DifferentialD]\[Theta]\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[
"A este mismo resultadose llega teniendo en cuenta que el \[AAcute]rea de \
\[CapitalOmega] viene dada por"], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{"  ", 
        RowBox[{
          RowBox[{
            FormBox[\(\[Lambda](\[CapitalOmega]) = 1\/2\ \),
              "TraditionalForm"], 
            \(\[Integral]\_\[Alpha]\%\[Beta]\((
                  \(x(\[Theta])\) y' \((\[Theta])\) - \ 
                    \(y(\[Theta])\) x' \((\[Theta])\))\) 
                \[DifferentialD]t\)}], "=", 
          RowBox[{
            RowBox[{"{", GridBox[{
                  {
                    \(x \((\[Theta])\) = 
                      \(f(\[Theta])\) cos \((\[Theta])\)\)},
                  {\(\ 
                    y \((\[Theta])\) = \(f(\[Theta])\) sen\ \((\[Theta])\)\)}
                  }], "}"}], "=", 
            \(\(1\/2\) 
              \(\[Integral]\_\[Alpha]\%\[Beta]\(\((f(\[Theta]))\)\^2\) 
                  \[DifferentialD]\[Theta]\)\)}]}]}], TraditionalForm]], 
  "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Con frecuencia, las ecuaciones en coordenadas polares se usan para \
representar distintos tipos de curvas sim\[EAcute]tricas llamadas ",
  StyleBox["\"rosas\"",
    FontSlant->"Italic"],
  ". Por ejemplo, aqu\[IAcute] tienes una rosa de 8 hojas o lazos. "
}], "Text"],

Cell[BoxData[
    \(\(\(\(PolarPlot[Cos[4  \[Theta]], {\[Theta], \(-\[Pi]\), \[Pi]}, 
        AspectRatio \[Rule] Automatic]; \)\ \) (*\ rosa\ de\ 8\ lazos\ *) 
      \)\)], "Input"],

Cell["\<\
La lemniscata es un tipo de rosa de 2 lazos. F\[IAcute]jate que las rosas no \
son curvas simples. Para calcular el \[AAcute]rea de la regi\[OAcute]n del \
plano encerrada por una rosa, es sufieciente, por simetr\[IAcute]a, calcular \
el \[AAcute]rea encerrada por un lazo y multiplicar por el n\[UAcute]mero de \
lazos. \
\>", "Text"],

Cell[CellGroupData[{

Cell["Ejemplos", "Subsubsection"],

Cell[TextData[{
  "\[FilledSmallCircle]",
  StyleBox[
  "  El \[AAcute]rea de la regi\[OAcute]n del plano rodeada por un lazo de la \
 lemniscata ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\(\ \[Rho]\^2 = \ cos(2  \[Theta])\)\)],
    FontWeight->"Plain"],
  StyleBox["  ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\((\(-\[Pi]\)/4 \[LessEqual] t \[LessEqual] \[Pi]/4)\),
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["es igual a ",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold"],

Cell[BoxData[
    FormBox[
      StyleBox[
        RowBox[{
          
          FormBox[\(\(1\/2\) 
                \(\[Integral]\_\(\(-\[Pi]\)/4\)\%\(\[Pi]/4\)\(cos(2 \[Theta])
                      \) \[DifferentialD]\[Theta]\) = \),
            "TraditionalForm"], " ", \(1\/2\)}],
        FontWeight->"Plain"], TextForm]], "Text",
  TextAlignment->Center]
}, Open  ]],

Cell[CellGroupData[{

Cell["  Ejercicios", "Subsection"],

Cell[TextData[{
  "6",
  StyleBox[
  "  Calcular el \[AAcute]rea limitada por el arco de la espiral de Arqu\
\[IAcute]mides ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Rho] = a\ \[Theta]\),
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox[" ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\((a > 0)\),
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["comprendido entre ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Theta] = 0\),
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox[" y ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          StyleBox[\(\[Theta] = \[Pi]\),
            FontWeight->"Plain"]}], TraditionalForm]]],
  ".",
  StyleBox["\n",
    FontWeight->"Plain"],
  "7",
  StyleBox[
  "  Hallar el \[AAcute]rea encerrada por el lazo interior de la curva ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\[Rho] = \ 1/2\  + cos\ \[Theta]\)],
    FontWeight->"Plain"],
  ".\n8  ",
  StyleBox[
  "Hallar el \[AAcute]rea encerrada por una de las hojas de la rosa ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Rho] = 2\ \(cos(2 \[Theta])\)\),
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox[".\n",
    FontWeight->"Plain"],
  "9 ",
  StyleBox[
  " Calcular el \[AAcute]rea del l\[OAcute]bulo del folium de Descartes de \
ecuaci\[OAcute]n ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\^3 + y\^3 - 3\ a\ x\ y = 0\),
          FontWeight->"Plain"], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        StyleBox[\((a > 0)\),
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox[".",
    FontWeight->"Plain"],
  " ",
  StyleBox[
  "Sugerencia: expresar la ecuaci\[OAcute]n en coordenadas polares.\n",
    FontWeight->"Plain"],
  "10",
  StyleBox[
  " Calcular el \[AAcute]rea de la regi\[OAcute]n com\[UAcute]n a las dos \
elipses ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(x\^2\/a\^2 + y\^2\/b\^2\),
              FontSize->18,
              FontWeight->"Plain"], 
            StyleBox["=",
              FontWeight->"Plain"], 
            StyleBox["1",
              FontWeight->"Plain"]}], 
          StyleBox[",",
            FontWeight->"Plain"], 
          RowBox[{
            StyleBox[\(x\^2\/b\^2 + y\^2\/a\^2\),
              FontSize->18,
              FontWeight->"Plain"], 
            StyleBox["=",
              FontWeight->"Plain"], 
            StyleBox["1",
              FontWeight->"Plain"]}]}], TraditionalForm]]],
  StyleBox[
  ". Sugerencia: Representar gr\[AAcute]ficamente las elipses. Usar la simetr\
\[IAcute]a polar para simplificar los c\[AAcute]lculos y pasar a coordenadas \
polares.",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Longitud de un arco de curva", "Section"],

Cell[TextData[{
  "Se trata de calcular la longitud de la curva ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\)]],
  " dada por la ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`y = f(x)\)]],
  ", donde suponemos que ",
  Cell[BoxData[
      \(TraditionalForm
      \`f : \([a, b]\) \[Rule] \ \[DoubleStruckCapitalR]\)]],
  " es una funci\[OAcute]n con derivada primera continua. Para ello \
aproximamos la curva por poligonales inscritas en ella. Cada \
partici\[OAcute]n  ",
  Cell[BoxData[
      \(TraditionalForm
      \`a = \(\(x\_0 < x\_1 < x\_2 < \  ... \)\  < x\_\(n - 1\) < x\_n = b
          \)\)]],
  " de",
  StyleBox[" ",
    FontSize->16],
  Cell[BoxData[
      \(TraditionalForm\`\([a, b]\)\)]],
  " induce una poligonal cuyos v\[EAcute]rtices son los puntos ",
  Cell[BoxData[
      \(TraditionalForm\`\((x\_k, f(x\_k))\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] k \[LessEqual] \ n\)]],
  ". El comando \"arclength[{x[t],y[t]},{t,a,b},n]\" (c\[OAcute]digo original \
de Xah Lee) representa la gr\[AAcute]fica de la curva cuyas ecuaciones param\
\[EAcute]tricas son ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          FormBox[
            RowBox[{" ", 
              RowBox[{"{", GridBox[{
                    {\(x = x(t)\)},
                    {\(y = y(t)\)}
                    }]}]}],
            "TraditionalForm"]}], TraditionalForm]]],
  " e inscribe en ella una pol\[IAcute]gonal de ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " lados que la divide en ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " partes que tienen la misma longitud. Tambi\[EAcute]n calcula la longitud \
de la poligonal que es una aproximaci\[OAcute]n a la longitud de la curva."
}], "Text"],

Cell[BoxData[
    \(\(\(arclength[{x, x\^2}, {x, \(-1\), 1}, 5];\)\(\ \)\( (*\ 
      una\ par\[AAcute]bola\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(\(arclength[{Cos[s], Sin[s]}, {s, 0, \[Pi]}, 7]; \)\ 
    \) (*\ la\ semicircunferencia\ unidad\ *) \)\)], "Input"],

Cell[BoxData[
    \(\(\ \(\(arclength[{\ Cos[2  \[Theta]] Cos[\[Theta]], 
        Cos[2  \[Theta]]\ Sin[\[Theta]]}, {\[Theta], 0, 2  \[Pi]}, 22, 
      AspectRatio \[Rule] Automatic]; 
    \)\  (*\ una\ rosa\ de\ cuatro\ hojas\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(arclength[{Cos[t]\/\(Sin[t]\^2 + 1\), 
        \(Sin[t]\ Cos[t]\)\/\(Sin[t]\^2 + 1\)}, {t, 0, \ 2  \[Pi]}, 12, 
      AspectRatio \[Rule] Automatic, ImageSize \[Rule] {417, 147.375}]; 
    \)\  (*\ la\ lemniscata\ *) \)\)], "Input"],

Cell[BoxData[
    \(\(\(arclength[{t\ Cos[t], \ t\ Sin[t]}, {t, 0, 6  \[Pi]}, 22, 
      AspectRatio \[Rule] Automatic, 
      ImageSize \[Rule] {692, 244.5}]\)\(;\)\(\ \)\( (*\ 
      tres\ vueltas\ de\ la\ espiral\ de\ Arqu\[IAcute]mides\ *) \)\)\)], \
"Input"],

Cell[TextData[{
  "La longitud de la poligonal de v\[EAcute]rtices ",
  Cell[BoxData[
      \(TraditionalForm\`\((x\_k, f(x\_k))\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] k \[LessEqual] \ n\)]],
  ", es igual a ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Sum]\+\(k = 1\)\%n
          \@\(\((x\_k - x\_\(k - 1\))\)\^2 + 
            \((f(x\_k) - f(x\_\(k - 1\)))\)\^2\)\)]],
  ". Por el teorema del valor medio, se verifica que ",
  Cell[BoxData[
      \(TraditionalForm
      \`f(x\_k) - f(x\_\(k - 1\)) = 
        f\ ' \((t\_k)\) \((x\_k - x\_\(k - 1\))\)\)]],
  " para alg\[UAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`t\_k\ \[Epsilon]\ [x\_\(k - 1\), x\_k]\)]],
  ". Por tanto\n",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Sum]\+\(k = 1\)\%n
            \@\(\((x\_k - x\_\(k - 1\))\)\^2 + 
              \((f(x\_k) - f(x\_\(k - 1\)))\)\^2\) = 
        \(\[Sum]\+\(k = 1\)\%n
              \@\(\((x\_k - x\_\(k - 1\))\)\^2 + 
                \((f\ ' \((t\_k)\) \((x\_k - x\_\(k - 1\))\))\)\^2\) = 
          \[Sum]\+\(k = 1\)\%n\(\@\( 1 + \((f' \((t\_k)\))\)\^2\)\) 
              \((x\_k - x\_\(k - 1\))\)\)\)]],
  "\npero esta es una suma de Riemann de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`x \[Rule] \ 1 + \((f\ ' \((x)\))\)\^2\)]],
  ". Deducimos que la longitud de ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\)]],
  " viene dada por"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["L",
            FontSize->14], "(", "\[Gamma]", ")"}], "=", 
        RowBox[{
          StyleBox[\(\[Integral]\_a\%b\),
            FontSize->14], 
          \(\(\@\(1 + \((f' \((x)\))\)\^2\)\) \[DifferentialD]x\)}]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Para el caso de que la curva ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\)]],
  " venga dada por las ecuaciones param\[EAcute]tricas ",
  Cell[BoxData[
      FormBox[
        TagBox[
          RowBox[{"{", GridBox[{
                {\(x = x(t)\)},
                {\(y = y(t)\)}
                }]}],
          (#&)], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\((a \[LessEqual] \ t \[LessEqual] \ b)\)\)]],
  " donde suponemos que las funciones ",
  Cell[BoxData[
      \(TraditionalForm\`t \[Rule] x(t), \ t \[Rule] \ y(t)\)]],
  "tienen derivada primera continua, razonando igual que antes se obtiene que \
la longitud de ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\)]],
  " es igual a"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["L",
            FontSize->14], "(", "\[Gamma]", ")"}], "=", 
        RowBox[{
          StyleBox[\(\[Integral]\_a\%b\),
            FontSize->14], 
          \(\(\@\(x' \((t)\)\^2 + y' \((t)\)\^2\)\) \[DifferentialD]t\)}]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Si la curva ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\)]],
  " viene dada en coordenadas polares por la ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\[Rho] = f(\[Theta])\)]],
  ", donde ",
  Cell[BoxData[
      \(TraditionalForm
      \`f : \([\[Alpha], \[Beta]]
            \)\[LongRightArrow]\[DoubleStruckCapitalR]\)]],
  " es una funci\[OAcute]n con derivada primera continua, entonces la \
longitud de ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\)]],
  " es igual a "
}], "Text"],

Cell[BoxData[
    \(TextForm
    \`L \((\[Gamma])\) = 
      \[Integral]\_\[Alpha]\%\[Beta]\(\@\(\((f \((\[Theta])\))\)\^2 + 
                \((f\ ' \((\[Theta])\))\)\^2\)\) \[DifferentialD]\[Theta]\)], 
  "Text",
  TextAlignment->Center],

Cell[TextData[{
  "F\[OAcute]rmula que puede deducirse de la anterior sin m\[AAcute]s que \
tener en cuenta que las ecuaciones par\[AAcute]metricas de la curva en cuesti\
\[OAcute]n son  ",
  Cell[BoxData[
      FormBox[
        TagBox[
          RowBox[{"{", GridBox[{
                {\(x = \(f(\[Theta])\)\ cos\ \[Theta]\)},
                {\(y = \(f(\[Theta])\)\ sen\ \[Theta]\)}
                }]}],
          (#&)], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm
      \`\((\[Alpha] \[LessEqual] \ \[Theta] \[LessEqual] \ \[Beta])\)\)]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[" Ejemplos", "Subsubsection"],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox[" La longitud del arco de la cateneria ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`y = cosh\ x\)],
    FontWeight->"Plain"],
  ", ",
  StyleBox["entre",
    FontWeight->"Plain"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`x = 0\)],
    FontWeight->"Plain"],
  " ",
  StyleBox["y",
    FontWeight->"Plain"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`x = 1\)],
    FontWeight->"Plain"],
  StyleBox[" e",
    FontWeight->"Plain"],
  "s ",
  StyleBox["igual a",
    FontWeight->"Plain"]
}], "Text"],

Cell[BoxData[
    \(TextForm
    \`\[Integral]\_0\%1\(\@\( 1 + \((senh\ x)\)\^2\)\) \[DifferentialD]x = 
      \(\[Integral]\_0\%1\(\@\( 1 + \((senh\ x)\)\^2\)\) \[DifferentialD]x = 
        \(\[Integral]\_0\%1 cosh\ x \[DifferentialD]x = 
          \(senh\ 1 = \(1\/2\) \((e\  - e\^\(-1\))\)\)\)\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "\[FilledSmallCircle] ",
  StyleBox[" La longitud de un arco de la cicloide ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x = t - \ sen\ t, \ y = \ 1 - cos\ t\),
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["es igual a ",
    FontWeight->"Plain"]
}], "Text"],

Cell[BoxData[
    FormBox[
      StyleBox[
        \(\[Integral]\_0\%\(2 \[Pi]\)\(\@\(x' \((t)\)\^2 + y' \((t)\)\^2\)\) 
              \[DifferentialD]t = 
          \(\[Integral]\_0
                \%\(2 \[Pi]\)\(\@\(\((1 - cos\ t)\)\^2 + \(sen\^2\) t\)\) 
                \[DifferentialD]t\  = 
            \(\[Integral]\_0\%\(2 \[Pi]\)\(\@\(2 - 2 cos\ t\)\) 
                  \[DifferentialD]t = 
              \(\[Integral]\_0
                    \%\(2 \[Pi]\)\(\@\(4 \(\(sen\^2\) \((\ t/2)\)\)\)\) 
                    \[DifferentialD]t = 
                \(\[Integral]\_0\%\(2 \[Pi]\)2\ \(sen \((t/2)\)\) 
                      \[DifferentialD]t = 8\)\)\)\)\),
        FontWeight->"Plain"], TextForm]], "Text",
  TextAlignment->Center]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicios", "Subsection"],

Cell[TextData[{
  "11",
  StyleBox["  Calcular la longitud del arco de curva ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`y = x\^2 + 4\)],
    FontWeight->"Plain"],
  StyleBox[",",
    FontWeight->"Plain"],
  " ",
  StyleBox["entre ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x = 0\),
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["y ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x = 3\),
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox[".",
    FontWeight->"Plain"],
  "\n12",
  StyleBox["  Calcular la longitud de la astroide  ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{
            RowBox[{
              SuperscriptBox[
                StyleBox[\((x\/a)\),
                  FontSize->18,
                  FontWeight->"Plain"], \(2/3\)], "+", " ", 
              SuperscriptBox[
                StyleBox[\((y\/a)\),
                  FontSize->18,
                  FontWeight->"Plain"], \(2/3\)]}], "=", "1"}],
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox[", ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\((a > 0)\)\)],
    FontWeight->"Plain"],
  StyleBox[
  ". Sugerencia: obtener las ecuaciones param\[EAcute]tricas de la astroide y \
tener en cuenta la simetr\[IAcute]a.\n",
    FontWeight->"Plain"],
  "13",
  StyleBox["  Calcular la longitud de la cardioide ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Rho] = 3 \((1 + cos\ \[Theta])\)\),
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox[", ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\((0 \[LessEqual] \[Theta] \[LessEqual] 2 \[Pi])\),
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox[".\n",
    FontWeight->"Plain"],
  "14",
  StyleBox[" Calcular la longitud de la curva ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Plain"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[\(\(\ x\^4 + 48\)\/\(24 x\)\),
            FontSize->18,
            FontWeight->"Plain"]}], TraditionalForm]]],
  StyleBox["donde ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(2 \[LessEqual] x \[LessEqual] 4\),
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox[".\n",
    FontWeight->"Plain"],
  "15",
  StyleBox[" Calcular la longitud de la curva ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(y = log \((1 - x\^2)\)\),
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["donde ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(1/3 \[LessEqual] x \[LessEqual] 2/3\),
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox[".",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Vol\[UAcute]menes de s\[OAcute]lidos en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]]
}], "Section"],

Cell[TextData[{
  "Al igual que podemos calcular \[AAcute]reas de regiones planas integrando \
las longitudes de sus secciones por rectas paralelas a una dada, podemos \
tambi\[EAcute]n calcular vol\[UAcute]menes de regiones en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  "integrando las \[AAcute]reas de sus secciones por planos paralelos a uno \
dado. Este resultado es un caso particular del teorema de Fubini.\n",
  StyleBox["C\[AAcute]lculo de vol\[UAcute]menes por secciones planas. ",
    FontWeight->"Bold"],
  StyleBox["El volumen de una regi\[OAcute]n en ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  Cell[BoxData[
      FormBox[
        SuperscriptBox["\[DoubleStruckCapitalR]", 
          StyleBox["3",
            FontWeight->"Bold"]], TraditionalForm]],
    FontSlant->"Italic"],
  StyleBox[
  "es igual a la integral del \[AAcute]rea de sus secciones por planos \
paralelos a uno dado.",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\nPara justificar esta afirmaci\[OAcute]n, sea \[CapitalOmega] una regi\
\[OAcute]n en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  "como la de la figura. "
}], "Text"],

Cell[BoxData[
    \(\(fig2;\)\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  "Representemos por ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega](x)\)]],
  " la secci\[OAcute]n de \[CapitalOmega] por el plano perpendicular al eje \
OX en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, 0, 0)\)\)]],
  ". Sea  ",
  Cell[BoxData[
      \(TraditionalForm\`V(x)\)]],
  " el volumen de la parte de \[CapitalOmega] que queda a la izquierda de \
dicho plano y sea ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda](\[CapitalOmega](x))\)]],
  " el \[AAcute]rea de la secci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega](x)\)]],
  ". Observa que la situaci\[OAcute]n es totalmente an\[AAcute]loga a la \
considerada en el Teorema Fundamental del C\[AAcute]lculo: all\[IAcute] ten\
\[IAcute]amos la funci\[OAcute]n \[AAcute]rea cuya derivada era la longitud \
de la secci\[OAcute]n. No debe sorprenderte por ello que ahora resulte que la \
derivada de la ",
  StyleBox["funci\[OAcute]n volumen",
    FontSlant->"Italic"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`V(x)\)]],
  ", sea el \[AAcute]rea de la secci\[OAcute]n. En efecto, sea ",
  Cell[BoxData[
      \(TraditionalForm\`h > 0\)]],
  ". Suponiendo, naturalmente, que la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`x \[Rule] \[Lambda](\[CapitalOmega](x))\)]],
  " es continua, tenemos que "
}], "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`\(\(min {
          \[Lambda](\[CapitalOmega](t)) : 
            x \[LessEqual] t \[LessEqual] x + h} h \[LessEqual] 
      V(x + h) - V(x) \[LessEqual] 
      max {\[Lambda](\[CapitalOmega](t)) : 
            x \[LessEqual] t \[LessEqual] x + h} h, \)\ \)\)], "Text",
  TextAlignment->Center],

Cell["de donde se deduce que ", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{" ", 
        RowBox[{
          FormBox[\(lim\_\(h \[Rule] 0, h > 0\)\),
            "TraditionalForm"], 
          FormBox[
            RowBox[{
              FractionBox[
                FormBox[\(V(x + h) - V(x)\),
                  "TraditionalForm"], "h"], "=", 
              \(\[Lambda](\[CapitalOmega](x))\)}],
            "TraditionalForm"]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "An\[AAcute]logamente se procede si ",
  Cell[BoxData[
      \(TraditionalForm\`h < 0\)]],
  ". Hemos obtenido as\[IAcute] que ",
  Cell[BoxData[
      \(TraditionalForm\`V' \((x)\) = \[Lambda](\[CapitalOmega](x))\)]],
  ". Deducimos que el volumen de \[CapitalOmega] viene dado por"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`Vol(\[CapitalOmega]) = 
      \(V(b) = \[Integral]\_a\%b\( \[Lambda](\[CapitalOmega](x))\) 
            \[DifferentialD]x\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Podemos llegar tambi\[EAcute]n a este resultado considerando sumas de \
Riemann. Para ello aproximamos la regi\[OAcute]n \[CapitalOmega] por \
cilindros de la siguiente forma. Consideremos una partici\[OAcute]n  ",
  Cell[BoxData[
      \(TraditionalForm\`a = \(\(x\_0 < x\_1 < x\_2 < \  ... \)\  < 
            x\_\(n - 1\) < x\_n = b\)\)]],
  " de",
  StyleBox[" ",
    FontSize->16],
  Cell[BoxData[
      \(TraditionalForm\`\([a, b]\)\)]],
  "; la parte de \[CapitalOmega] comprendida entre los planos perpendiculares \
al eje OX por los puntos ",
  Cell[BoxData[
      \(TraditionalForm\`\((x\_\(k - 1\), 0, 0)\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\((x\_k, 0, 0)\)\)]],
  " puede aproximarse por un cilindro de altura ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(x\_k\),
            "TraditionalForm"], "-", \(x\_\(k - 1\)\)}], TraditionalForm]]],
  " y base ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega](x\_k)\)]],
  " cuyo volumen es igual a ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[Lambda](\[CapitalOmega](x\_k))\) \((x\_k - 
            x\_\(k - 1\))\)\)]],
  ". Observa la figura (ten paciencia, tarda un poco)."
}], "Text"],

Cell[BoxData[{
    \(\(fig3 := 
        Module[{f}, 
          f[x_] = Apply[Plus, 
              Table[\((\(-UnitStep[x - \((k + 1/5)\)]\) + 
                      UnitStep[x - k])\) \@\(1 - k\^2/4\), {k, \(-2\), 
                  2 + 1/5, 1/5}]]; 
          SurfaceOfRevolution[Evaluate[f[x]], {x, \(-2\), 2}, 
            RevolutionAxis \[Rule] {1, 0, 0}, AspectRatio \[Rule] Automatic, 
            PlotPoints \[Rule] 50, 
            ViewPoint -> {\(-0.012\), \ \(-3.277\), \ 0.845}, 
            ImageSize \[Rule] {510, 283.75}, Axes \[Rule] False, 
            Boxed \[Rule] False, 
            LightSources \[Rule] {{{2, 1, 1}, RGBColor[1, 0, 0]}, {{0, 0, 0}, 
                  RGBColor[0, 1, 1]}, {{\(-2\), 1, 1}, 
                  RGBColor[0, 1, 1]}}]];\)\), "\n", 
    \(\(fig3;\)\)}], "Input"],

Cell[TextData[{
  "La suma de los vol\[UAcute]menes de todos estos cilindros, ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Sum]\+\(k = 1\)\%n\( \[Lambda](\[CapitalOmega](x\_k))\) 
          \((x\_k - x\_\(k - 1\))\)\)]],
  " es por tanto una aproximaci\[OAcute]n del volumen de \[CapitalOmega], \
pero dicha suma es una suma de Riemann de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`x \[Rule] \[Lambda](\[CapitalOmega](x))\)]],
  "  ",
  Cell[BoxData[
      \(TraditionalForm\`\((a \[LessEqual] x \[LessEqual] b)\)\)]],
  ", por lo que el volumen de \[CapitalOmega] es igual a ",
  Cell[BoxData[
      \(TraditionalForm
      \`Vol(\[CapitalOmega]) = 
        \[Integral]\_a\%b\( \[Lambda](\[CapitalOmega](x))\) 
            \[DifferentialD]x\)]],
  ".\nVamos a estudiar algunos casos en los que es f\[AAcute]cil calcular el \
\[AAcute]rea de las secciones de \[CapitalOmega]."
}], "Text"],

Cell[CellGroupData[{

Cell["Volumen de un cuerpo de revoluci\[OAcute]n", "Subsection"],

Cell[TextData[{
  "Los cuerpos de revoluci\[OAcute]n o s\[OAcute]lidos de revoluci\[OAcute]n \
son regiones de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  "que se obtienen girando una regi\[OAcute]n plana alrededor de una recta \
llamada eje de giro. La orden \"SurfaceOfRevolution[f[x],{x,a,b},opts]\"  \
representa la superficie de revoluci\[OAcute]n obtenida girando la \
gr\[AAcute]fica de f en el plano YZ. Este comando tiene muchas opciones, b\
\[UAcute]scalas en la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Aqu\[IAcute] tienes el s\[OAcute]lido de revoluci\[OAcute]n engendrado \
al girar alrededor del eje OX la gr\[AAcute]fica de la funci\[OAcute]n seno \
entre 0 y \[Pi]."
}], "Text"],

Cell[BoxData[
    \(\(Show[
        GraphicsArray[{SurfaceOfRevolution[Sin[x], {x, 0, \[Pi]}, 
              RevolutionAxis \[Rule] {1, 0, 0}, PlotPoints \[Rule] 50, 
              AspectRatio \[Rule] Automatic, 
              ViewPoint -> {\(-0.012\), \ \(-3.277\), \ 0.845}, 
              Axes \[Rule] False, Boxed \[Rule] False, 
              DisplayFunction \[Rule] Identity], 
            Plot[Sin[x], {x, 0, \[Pi]}, DisplayFunction \[Rule] Identity, 
              AspectRatio \[Rule] 1/2.5]}], 
        DisplayFunction \[Rule] $DisplayFunction, 
        ImageSize \[Rule]  .7*{825, 459}];\)\)], "Input"],

Cell[CellGroupData[{

Cell["\<\
 M\[EAcute]todo de los discos: secciones perpendiculares al eje de giro\
\>", "Subsubsection"],

Cell[TextData[{
  "Sea ",
  Cell[BoxData[
      \(TraditionalForm\`f : \([a, b]\) \[Rule] \[DoubleStruckCapitalR]\)]],
  " una funci\[OAcute]n continua. Girando la regi\[OAcute]n del plano \
comprendida entre la curva ",
  Cell[BoxData[
      \(TraditionalForm\`y = \ f(x)\)]],
  ", el eje de abscisas y las rectas ",
  Cell[BoxData[
      \(TraditionalForm\`y = a\)]],
  " e ",
  Cell[BoxData[
      \(TraditionalForm\`y = b\)]],
  ",  alrededor del eje OX obtenemos un s\[OAcute]lido de revoluci\[OAcute]n \
",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega]\)]],
  ". Es evidente que la secci\[OAcute]n, ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega](x)\)]],
  ", de ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega]\)]],
  " por el plano perpendicular al eje OX en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, 0, 0)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\((a \[LessEqual] x \[LessEqual] b)\)\)]],
  ", es un disco contenido en dicho plano de centro",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          FormBox[\((x, 0, 0)\),
            "TraditionalForm"]}], TraditionalForm]]],
  " y radio ",
  Cell[BoxData[
      \(TraditionalForm\`\(| f(x) | \)\)]],
  ". Por tanto el \[AAcute]rea de ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega](x)\)]],
  " es ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Lambda](\[CapitalOmega](x)) = \[Pi]\ \(f(x)\)\^2\)]],
  "; en consecuencia el volumen de \[CapitalOmega] es igual a"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`Vol(\[CapitalOmega]) = 
      \[Pi] \(\[Integral]\_a\%b\(\((f(x))\)\^2\) \[DifferentialD]x\)\)], 
  "Text",
  TextAlignment->Center],

Cell[TextData[{
  "El volumen del s\[OAcute]lido de revoluci\[OAcute]n, \[CapitalOmega], \
obtenido girando alrededor del eje OX una regi\[OAcute]n de tipo I definida \
por dos funciones continuas ",
  Cell[BoxData[
      \(TraditionalForm\`f, 
      g : \([a, b]\) \[Rule] \[DoubleStruckCapitalR]\)]],
  " tales que ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] f(x) \[LessEqual] g(x)\)]],
  " para todo ",
  Cell[BoxData[
      \(TraditionalForm\`x\ \[Epsilon]\ [a, b]\)]],
  ", viene dado por"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{" ", 
        FormBox[
          \(Vol(\[CapitalOmega]) = 
            \[Pi] \(\[Integral]\_a\%b\((\(g(x)\)\^2 - \(f(x)\)\^2)\) 
                  \[DifferentialD]x\)\),
          "TraditionalForm"]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["\<\
Una expresi\[OAcute]n similar se obtiene para el volumen de un s\[OAcute]lido \
de revoluci\[OAcute]n obtenido girando alrededor del eje OY una \
regi\[OAcute]n de tipo II.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[" Ejemplos", "Subsubsection"],

Cell[TextData[{
  "\[FilledSmallCircle]  El volumen de la esfera obtenida girando la \
circunferencia ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 = R\^2\)]],
  " alrededor del eje OX es igual a  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
        \(\[Pi] \(\[Integral]\_\(-R\)\%R\((R\^2 - x\^2)\) 
                \[DifferentialD]x\)\), "=", 
          FormBox[\(\(4\ \[Pi]\ R\^3\)\/3\),
            "TraditionalForm"]}], TraditionalForm]]],
  ".\n\[FilledSmallCircle]  Un cono circular recto de altura ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  " y radio de la base ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  " se obtiene girando la recta ",
  Cell[BoxData[
      \(TraditionalForm\`y = R\ x/h\)]],
  " entre 0 y ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  ". Su volumen es igual a ",
  Cell[BoxData[
      FormBox[
        RowBox[{
        \(\[Pi]\ \(\[Integral]\_0\%h\(\((R\ x/h)\)\^2\) 
                \[DifferentialD]x\)\), "=", 
          FormBox[\(1\/3\ \[Pi]\ \(R\^2\) h\),
            "TraditionalForm"]}], TraditionalForm]]],
  "."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["  Ejercicios", "Subsection"],

Cell[TextData[{
  "16  ",
  StyleBox[
  "Calcular el  volumen del s\[OAcute]lido engendrado al girar alrededor del \
eje OX la parte de la curva ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(y = \ sen\^2\ x\),
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["comprendida entre ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x = 0\),
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["y ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`x = \[Pi]\)],
    FontWeight->"Plain"],
  ".\n17",
  StyleBox[
  "  Calcular el  volumen del s\[OAcute]lido engendrado al girar alrededor \
del eje OX la gr\[AAcute]fica de la funci\[OAcute]n ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(f : \),
          FontWeight->"Plain"], TraditionalForm]]],
  "[",
  Cell[BoxData[
      FormBox[
        StyleBox[\(0, \(+\[Infinity]\)\),
          FontWeight->"Plain"], TraditionalForm]]],
  "[",
  Cell[BoxData[
      FormBox[
        StyleBox[\( \[Rule] \[DoubleStruckCapitalR]\),
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["dada por ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(f(x)\),
            FontWeight->"Plain"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[\(\(18\ x\)\/\(x\^2 + 9\)\),
            FontSize->18,
            FontWeight->"Plain"]}], TraditionalForm]]],
  StyleBox[".",
    FontWeight->"Plain"],
  "\n18",
  StyleBox[
  "  Calcular el volumen del s\[OAcute]lido engendrado al girar la regi\
\[OAcute]n limitada por la par\[AAcute]bola ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`y\^2 = 4  x\)],
    FontWeight->"Plain"],
  " ",
  StyleBox["y la recta ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\  = 4\),
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["alrededor de dicha recta.\n",
    FontWeight->"Plain"],
  "19",
  StyleBox[
  "  Calcular el volumen del s\[OAcute]lido engendrado al girar la regi\
\[OAcute]n limitada por las par\[AAcute]bolas ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SuperscriptBox[
              StyleBox["y",
                FontWeight->"Plain"], "2"], "=", "x"}], ",", " ", 
          \(x\^2 = y\)}], TraditionalForm]],
    FontWeight->"Plain"],
  StyleBox[" alrededor del eje OX.",
    FontWeight->"Plain"],
  "\n20",
  StyleBox["  Calcular el volumen del elipsoide ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(x\^2\/a\^2 + y\^2\/b\^2 + z\^2\/c\^2\),
            FontSize->14,
            FontWeight->"Plain"], 
          StyleBox["=",
            FontSize->12,
            FontWeight->"Plain"], 
          StyleBox["1",
            FontSize->12,
            FontWeight->"Plain"]}], TraditionalForm]]],
  StyleBox[". ",
    FontWeight->"Plain"],
  "\n21",
  StyleBox[" Calcular el volumen limitado por el paraboloide ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\^2\/9 + y\^2\/16 = z\),
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox[" y el plano ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`z = 7\)],
    FontWeight->"Plain"],
  ". "
}], "Text",
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[" M\[EAcute]todo de las l\[AAcute]minas o de los tubos", "Subsubsection"],

Cell[TextData[{
  "Consideremos la gr\[AAcute]fica de una funci\[OAcute]n positiva ",
  Cell[BoxData[
      \(TraditionalForm\`y = f(x)\)]],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`a \[LessEqual] x \[LessEqual] b\)]],
  ". Por ejemplo"
}], "Text"],

Cell[BoxData[
    \(\(Plot[1 - x\^2, {x, 0, 1}, AspectRatio \[Rule] Automatic]; \)\)], 
  "Input"],

Cell["Giremos dicha gr\[AAcute]fica alrededor del eje OY.", "Text"],

Cell[BoxData[
    \(\(SurfaceOfRevolution[1 - x\^2, {x, 0, 1}, 
        RevolutionAxis \[Rule] {0, 0, 1}, PlotPoints \[Rule] 50, 
        AspectRatio \[Rule] Automatic, Axes \[Rule] False, 
        Boxed \[Rule] False];\)\)], "Input"],

Cell[TextData[
"Obtenemos as\[IAcute] un s\[OAcute]lido de revoluci\[OAcute]n, \
\[CapitalOmega], cuyo volumen podemos aproximar considerando \
rect\[AAcute]ngulos verticales inscritos en la gr\[AAcute]fica y \
gir\[AAcute]ndolos alrededor del eje OY.  "], "Text"],

Cell[BoxData[
    \(Clear[h]; h[x_] = stepfunc[1 - x\^2, {x, 0, 1}, 8]; 
    Show[GraphicsArray[{disco1[1 - x\^2, {x, 0, 1, 9}, 
            AspectRatio \[Rule] Automatic], 
          SurfaceOfRevolution[h[x], {x, 0, 1}, 
            RevolutionAxis \[Rule] {0, 0, 1}, PlotPoints \[Rule] 50, 
            AspectRatio \[Rule] Automatic, Axes \[Rule] False, 
            Boxed \[Rule] False, DisplayFunction \[Rule] Identity]}], 
      ImageSize \[Rule]  .75*{793.563, 377.625}, 
      DisplayFunction \[Rule] $DisplayFunction]; Clear[h];\)], "Input"],

Cell["\<\
Ejecuta la siguiente celda para ver c\[OAcute]mo la aproximaci\[OAcute]n va \
mejorando a medidad que aumentamos el n\[UAcute]mero de puntos de divisi\
\[OAcute]n del intervalo.\
\>", "Text"],

Cell[BoxData[{
    \(h[x_, k_] := stepfunc[1 - x\^2, {x, 0, 1}, k]; 
    Do[Show[GraphicsArray[{disco1[1 - x\^2, {x, 0, 1, k}, 
              AspectRatio \[Rule] Automatic], 
            SurfaceOfRevolution[Evaluate[h[x, k]], {x, 0, 1}, 
              RevolutionAxis \[Rule] {0, 0, 1}, PlotPoints \[Rule] 50, 
              AspectRatio \[Rule] Automatic, Axes \[Rule] False, 
              Boxed \[Rule] False, DisplayFunction \[Rule] Identity]}], 
        ImageSize \[Rule]  .75*{793.563, 377.625}, 
        DisplayFunction \[Rule] $DisplayFunction], {k, 9, 19, 2}];\), "\n", 
    \(\(SelectionMove[EvaluationNotebook[], All, GeneratedCell];\)\), "\n", 
    \(FrontEndTokenExecute["\<CellGroup\>"]\), "\n", 
    \(FrontEndTokenExecute["\<OpenCloseGroup\>"]\)}], "Input"],

Cell[TextData[{
  "Esto es lo que se conoce como ",
  StyleBox["m\[EAcute]todo de las l\[AAcute]minas o de los tubos",
    FontSlant->"Italic"],
  ". Observa que, a diferencia del m\[EAcute]todo de los discos en el que se \
consideran rect\[AAcute]ngulos perpendiculares al eje de giro, en el m\
\[EAcute]todo de las l\[AAcute]minas o de los tubos los ",
  StyleBox["rect\[AAcute]ngulos considerados son paralelos al eje de giro",
    FontSlant->"Italic"],
  ".\nConsideremos una partici\[OAcute]n  ",
  Cell[BoxData[
      \(TraditionalForm
      \`a = \(\(x\_0 < x\_1 < x\_2 < \  ... \)\  < x\_\(n - 1\) < x\_n = b
          \)\)]],
  " de",
  StyleBox[" ",
    FontSize->16],
  Cell[BoxData[
      \(TraditionalForm\`\([a, b]\)\)]],
  ". El volumen del s\[OAcute]lido engendrado al girar alrededor del eje OY \
un rect\[AAcute]ngulo vertical cuya base es el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([x\_\(k - 1\), x\_k]\)\)]],
  " y altura ",
  Cell[BoxData[
      \(TraditionalForm\`f(x\_k)\)]],
  " es igual a  ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\ \((x\_k\%2 - x\_\(k - 1\)\%2)\)\)]],
  Cell[BoxData[
      \(TraditionalForm
      \`f(x\_k) = 
        \(\[Pi](x\_k + x\_\(k - 1\))\) \(f(x\_k)\) 
          \((x\_k - x\_\(k - 1\))\)\)]],
  ". La suma de todos ellos es igual a"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`\[Sum]\+\(k = 1\)\%n\( \[Pi](x\_k + x\_\(k - 1\))\) \(f(x\_k)\) 
          \((x\_k - x\_\(k - 1\))\) = 
      \[Sum]\+\(k = 1\)\%n \[Pi]\ \(x\_k\) \(f(x\_k)\) 
            \((x\_k - x\_\(k - 1\))\) + 
        \[Sum]\+\(k = 1\)\%n \[Pi]\ \(x\_\(k - 1\)\) \(f(x\_k)\) 
            \((x\_k - x\_\(k - 1\))\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Como las sumas ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Sum]\+\(k = 1\)\%n \[Pi]\ \(x\_k\) \(f(x\_k)\) 
          \((x\_k - x\_\(k - 1\))\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Sum]\+\(k = 1\)\%n \[Pi]\ \(x\_\(k - 1\)\) \(f(x\_k)\) 
          \((x\_k - x\_\(k - 1\))\)\)]],
  " son sumas de Riemann de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`x \[Rule] \ \[Pi]\ x\ \(f(x)\)\)]],
  ", deducimos que el volumen de \[CapitalOmega] viene dado por"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`Vol(\[CapitalOmega]) = 
      2  \[Pi] \(\[Integral]\_a\%b x\ \(f(x)\) \[DifferentialD]x\)\)], "Text",\

  TextAlignment->Center],

Cell[TextData[{
  " Puedes adaptar f\[AAcute]cilmente esta expresi\[OAcute]n para el caso de \
que el eje de giro sea la recta vertical ",
  Cell[BoxData[
      \(TraditionalForm\`x = c\)]],
  ". En general, si notamos por ",
  Cell[BoxData[
      \(TraditionalForm\`R(x)\)]],
  " el ",
  StyleBox["\"radio de giro\"",
    FontSlant->"Italic"],
  " de la l\[AAcute]mina, entonces"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`Vol(\[CapitalOmega]) = 
      2  \[Pi] \(\[Integral]\_a\%b\( R(x)\)\ \(f(x)\) \[DifferentialD]x\)\)], 
  "Text",
  TextAlignment->Center]
}, Open  ]],

Cell[CellGroupData[{

Cell[" Ejemplos", "Subsubsection"],

Cell[TextData[{
  "\[FilledSmallCircle]",
  StyleBox[
  "  Consideremos el toro \[DoubleStruckCapitalT] obtenido al girar el disco \
de centro ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\((a, 0)\)\ \),
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox[", ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(a > 0\),
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox[", y radio ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox["R",
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["alrededor del eje OY. Puedes verlo para ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`a = 2\)],
    FontWeight->"Plain"],
  StyleBox[" y ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`R = 1\)],
    FontWeight->"Plain"],
  " ",
  StyleBox["ejecutando la siguiente celda.",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold"],

Cell[BoxData[
    \(\(Show[{SurfaceOfRevolution[\@\(1 - \((x - 2)\)\^2\), {x, 1, 3}, 
            RevolutionAxis \[Rule] {0, 0, 1}, AspectRatio \[Rule] Automatic, 
            Axes \[Rule] False, Boxed \[Rule] False, 
            DisplayFunction \[Rule] Identity], 
          SurfaceOfRevolution[\(-\@\(1 - \((x - 2)\)\^2\)\), {x, 1, 3}, 
            RevolutionAxis \[Rule] {0, 0, 1}, PlotPoints \[Rule] 50, 
            AspectRatio \[Rule] Automatic, Axes \[Rule] False, 
            Boxed \[Rule] False, DisplayFunction \[Rule] Identity]}, 
        DisplayFunction \[Rule] $DisplayFunction];\)\)], "Input"],

Cell[TextData[{
  "Por simetr\[IAcute]a, su volumen es el doble del volumen del \
s\[OAcute]lido obtenido al girar la semicircunferencia ",
  Cell[BoxData[
      \(TraditionalForm\`y = \@\(R\^2 - \((x - a)\)\^2\), \ 
      \((a - R \[LessEqual] x \[LessEqual] a + R)\)\)]],
  " alrededor del eje OY. Por tanto"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(Vol(\[DoubleStruckCapitalT])\), "=", 
        RowBox[{
        \(4  \[Pi] 
            \(\[Integral]\_\(a - R\)\%\(a + R\)x 
                \(\@\( R\^2 - \((x - a)\)\^2\)\) \[DifferentialD]x\)\), "=", 
          FormBox[\(2\ a\ \[Pi]\^2\ R\^2\ \),
            "TraditionalForm"]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  StyleBox["\[FilledSmallCircle]",
    FontWeight->"Bold"],
  StyleBox[
  "  Calcular el volumen del s\[OAcute]lido \[CapitalOmega] engendrado al \
girar la regi\[OAcute]n limitada por las par\[AAcute]bolas ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SuperscriptBox[
              StyleBox["y",
                FontWeight->"Plain"], "2"], "=", "x"}], ",", " ", 
          \(x\^2 = y\)}], TraditionalForm]],
    FontWeight->"Plain"],
  StyleBox[" alrededor del eje OY.",
    FontWeight->"Plain"]
}], "Text"],

Cell[BoxData[
    \(\(Plot[{\@x, x\^2}, {x, 0, 1}]; \)\)], "Input"],

Cell[BoxData[
    \(\(Show[{SurfaceOfRevolution[\@x, {x, 0, 1}, {t, \[Pi], 2  \[Pi]}, 
            RevolutionAxis \[Rule] {1, 0, 0}, PlotPoints \[Rule] 50, 
            AspectRatio \[Rule] Automatic, Axes \[Rule] False, 
            Boxed \[Rule] False, DisplayFunction \[Rule] Identity], 
          SurfaceOfRevolution[x\^2, {x, 0, 1}, 
            RevolutionAxis \[Rule] {1, 0, 0}, PlotPoints \[Rule] 50, 
            AspectRatio \[Rule] Automatic, Axes \[Rule] False, 
            Boxed \[Rule] False, DisplayFunction \[Rule] Identity]}, 
        ImageSize \[Rule]  .7*{793.563, 377.625}, 
        DisplayFunction \[Rule] $DisplayFunction, 
        ViewPoint -> {\(-0.012\), \ \(-3.382\), \ 0.109}];\)\)], "Input"],

Cell[TextData[{
  "El s\[OAcute]lido de revoluci\[OAcute]n engendrado es una especie de \
embudo acotado por dos superficies de revoluci\[OAcute]n, la superior \
obtenida al girar la gr\[AAcute]fica ",
  Cell[BoxData[
      \(TraditionalForm\`y = \@x\)]],
  "y la inferior obtenida al girar ",
  Cell[BoxData[
      \(TraditionalForm\`y = x\^2\)]],
  ". El volumen pedido viene, por tanto, dado por  ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(Vol(\[CapitalOmega])\), "=", 
          RowBox[{
          \(2  \[Pi] 
              \(\[Integral]\_0\%1\((x \@ x - x\^3)\) \[DifferentialD]x\)\), 
            "=", 
            FormBox[\(\(3\ \[Pi]\)\/10\),
              "TraditionalForm"]}]}], TraditionalForm]]],
  "."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["  Ejercicios", "Subsection"],

Cell[TextData[{
  StyleBox["22",
    FontWeight->"Bold"],
  "  ",
  StyleBox[
  "Calcular el  volumen del toro engendrado al girar el c\[IAcute]rculo de \
centro 0 y radio 3 alrededor de la recta ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`x = 6\)]],
  ".\n",
  StyleBox["23",
    FontWeight->"Bold"],
  StyleBox[
  "  Calcular el volumen del s\[OAcute]lido \[CapitalOmega] engendrado al \
girar la regi\[OAcute]n limitada por las par\[AAcute]bolas ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SuperscriptBox[
              StyleBox["y",
                FontWeight->"Plain"], "2"], "=", "x"}], ",", " ", 
          \(x\^2 = y\)}], TraditionalForm]],
    FontWeight->"Plain"],
  StyleBox[" alrededor de la recta ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`x = 4\)]],
  "."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\[CapitalAAcute]rea de una superficie de revoluci\[OAcute]n", "Section"],

Cell[TextData[{
  "Una superficie de revoluci\[OAcute]n se obtiene girando una curva dada \
alrededor de una recta. Sea ",
  Cell[BoxData[
      \(TraditionalForm\`f : \([a, b]\) \[Rule] \[DoubleStruckCapitalR]\)]],
  " una funci\[OAcute]n con derivada primera continua. Girando la \
gr\[AAcute]fica de dicha funci\[OAcute]n alrededor del eje OX obtenemos una \
superficie de revoluci\[OAcute]n, \[CapitalGamma]. F\[IAcute]jate en la \
siguiente representaci\[OAcute]n."
}], "Text"],

Cell[BoxData[
    \(\(fig4;\)\)], "Input",
  InitializationCell->True],

Cell[TextData[{
  "Sea ",
  Cell[BoxData[
      \(TraditionalForm\`S(x)\)]],
  " el \[AAcute]rea de la parte de la superficie comprendida entre los planos \
",
  Cell[BoxData[
      \(TraditionalForm\`X = a\)]],
  ", y ",
  Cell[BoxData[
      \(TraditionalForm\`X = x\)]],
  ". Representemos por ",
  Cell[BoxData[
      \(TraditionalForm\`L(x)\)]],
  " la longitud de la gr\[AAcute]fica de ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " entre ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". Recuerda que ",
  Cell[BoxData[
      \(TraditionalForm
      \`L(x) = \[Integral]\_a\%x\(\@\( 1 + f' \((t)\)\^2\)\) 
            \[DifferentialD]t\)]],
  ". Teniendo en cuenta que el \[AAcute]rea lateral de un cilindro circular \
recto es igual a la longitud de la base por la altura, se deduce que"
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`2  \[Pi]\ min\)]],
  "{",
  Cell[BoxData[
      \(TraditionalForm\`f(t) : x \[LessEqual] t \[LessEqual] x + h\)]],
  "}",
  Cell[BoxData[
      \(TraditionalForm
      \`\((L(x + h) - L(x))\) \[LessEqual] S(x + h) - S(x) \[LessEqual] 
        2  \[Pi]\ max\)]],
  "{",
  Cell[BoxData[
      \(TraditionalForm\`f(t) : x \[LessEqual] t \[LessEqual] x + h\)]],
  "}",
  Cell[BoxData[
      \(TraditionalForm\`\((L(x + h) - L(x))\)\)]]
}], "Text",
  TextAlignment->Center],

Cell["Por tanto ", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{"2", "\[Pi]", " ", "min", 
        RowBox[{"{", 
          FormBox[\(f(t) : x \[LessEqual] t \[LessEqual] x + h\),
            "TraditionalForm"], "}"}], 
        FormBox[
          \(\(L(x + h) - L(x)\)\/h \[LessEqual] \(S(x + h) - S(x)\)\/h 
            \[LessEqual] 2  \[Pi]\ max\),
          "TraditionalForm"], 
        RowBox[{"{", 
          FormBox[\(f(t) : x \[LessEqual] t \[LessEqual] x + h\),
            "TraditionalForm"], "}"}], 
        FormBox[\(\(L(x + h) - L(x)\)\/h\),
          "TraditionalForm"]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Tomando l\[IAcute]mites para ",
  Cell[BoxData[
      \(TraditionalForm\`h \[Rule] 0\)]],
  " deducimos que ",
  Cell[BoxData[
      \(TraditionalForm
      \`S' \((x)\) = 
        \(2  \[Pi]\ \(f(x)\)\ L' \((x)\) = 
          2  \[Pi]\ \(f(x)\) \@\(1 + f' \((x)\)\^2\)\)\)]],
  ". Luego el \[AAcute]rea de la superficie  \[CapitalGamma] viene dada por "
}], "Text"],

Cell[BoxData[
    \(TraditionalForm
    \`\[Lambda](\[CapitalGamma]) = 
      2  \[Pi] \(\[Integral]\_a\%b\( f(x)\) \(\@\(1 + f' \((x)\)\^2\)\) 
            \[DifferentialD]x\)\)], "Text",
  TextAlignment->Center],

Cell[CellGroupData[{

Cell[" Ejemplos", "Subsubsection"],

Cell[TextData[{
  "\[FilledSmallCircle]  El \[AAcute]rea de una superficie esf\[EAcute]rica \
de radio ",
  StyleBox["R",
    FontSlant->"Italic"],
  " viene dada por ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"2", "\[Pi]", 
            RowBox[{\(\[Integral]\_\(-R\)\%R\), 
              RowBox[{\(\@\(R\^2 - x\^2\)\), 
                SqrtBox[
                  RowBox[{"1", "+", 
                    SuperscriptBox[
                      RowBox[{"(", 
                        StyleBox[\(\(-x\)\/\@\(R\^2 - x\^2\)\),
                          FontSize->18], 
                        StyleBox[")",
                          FontSize->18]}], "2"]}]], 
                \(\[DifferentialD]x\)}]}]}], "=", 
          FormBox[\(4\ \[Pi]\ R\^2\),
            "TraditionalForm"]}], TraditionalForm]]],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["  Ejercicios", "Subsection"],

Cell[TextData[{
  StyleBox["24",
    FontWeight->"Bold"],
  "  ",
  StyleBox[
  "Calcular el  \[AAcute]rea de la superficie de revoluci\[OAcute]n \
engendrada al girar la curva ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`y = x\^3\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] x \[LessEqual] 1\)]],
  ", alrededor del eje OX.\n",
  StyleBox["25",
    FontWeight->"Bold"],
  StyleBox[
  "  Calcular el \[AAcute]rea de la superficie de revoluci\[OAcute]n \
engendrada al girar la curva ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\(x\^\(2/3\) + y\^\(2/3\) = a\^\(2/3\), \)\)]],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\((a > 0)\)\)]],
  ", alrededor del eje OX.\n",
  StyleBox["26  ",
    FontWeight->"Bold"],
  StyleBox[
  "Calcular el \[AAcute]rea de la superficie de revoluci\[OAcute]n engendrada \
al girar la elipse ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(x\^2\/4 + y\^2\/9\),
            FontSize->18], "=", "1"}], TraditionalForm]]],
  " alrededor del eje OY.\n",
  StyleBox["27  ",
    FontWeight->"Bold"],
  StyleBox[
  "Calcular el \[AAcute]rea de la superficie de revoluci\[OAcute]n engendrada \
al girar la catenaria ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`y = cosh\ x\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] x \[LessEqual] 1\)]],
  ", alrededor del eje OX.\n",
  StyleBox["28  ",
    FontWeight->"Bold"],
  "Al girar alrededor del eje OX el segmento de par\[AAcute]bola ",
  Cell[BoxData[
      \(TraditionalForm\`y = \@x\)]],
  ",  ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] x \[LessEqual] a\)]],
  ", engendra un tronco de paraboloide de revoluci\[OAcute]n cuya superficie \
tiene \[AAcute]rea igual a la de una esfera de radio ",
  Cell[BoxData[
      \(TraditionalForm\`\@\(13/12\)\)]],
  ". Se pide calcular el valor de ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  ".\n",
  StyleBox["29 ",
    FontWeight->"Bold"],
  "Comprueba que el \[AAcute]rea de la superficie de revoluci\[OAcute]n \
(llamada ",
  StyleBox["horno de Gabriel",
    FontSlant->"Italic"],
  ") engendrada al girar la curva ",
  Cell[BoxData[
      \(TraditionalForm\`y = 1/x\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`1 \[LessEqual] x < \(+\[Infinity]\)\)]],
  ", alrededor del eje OX es infinita (por tanto ser\[IAcute]a necesaria una \
cantidad infinita de pintura si quisi\[EAcute]ramos pintarla) pero el volumen \
del s\[OAcute]lido de revoluci\[OAcute]n engendrado es finito (por tanto \
podemos llenarlo con una cantidad finita de pintura). Comenta a tu gusto esta \
aparente paradoja.\n",
  StyleBox["30",
    FontWeight->"Bold"],
  " Calcular el \[AAcute]rea de un espejo parab\[OAcute]lico de 3 metros de \
di\[AAcute]metro y 1 metro de fondo."
}], "Text"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
AutoGeneratedPackage->Automatic,
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PageHeaders->{{Inherited, Inherited, Inherited}, {Cell[ 
        TextData[ "Aplicaciones de las integrales"], "Header"], Cell[ 
        TextData[ "Prof. Javier P\[EAcute]rez"], "Header"], Inherited}},
CellLabelAutoDelete->True,
Magnification->1.25,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 55, 0, 83, "Title"],
Cell[1812, 53, 244, 10, 95, "Text",
  PageBreakBelow->False],

Cell[CellGroupData[{
Cell[2081, 67, 39, 0, 77, "Section"],
Cell[2123, 69, 552, 10, 108, "Text"],
Cell[2678, 81, 454, 9, 198, "Text"],
Cell[3135, 92, 202, 3, 33, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3374, 100, 41, 0, 77, "Section"],
Cell[3418, 102, 73, 2, 60, "Input",
  InitializationCell->True],
Cell[3494, 106, 87, 2, 60, "Input",
  InitializationCell->True],
Cell[3584, 110, 519, 9, 144, "Input",
  InitializationCell->True],
Cell[4106, 121, 2845, 51, 585, "Input",
  InitializationCell->True],
Cell[6954, 174, 2904, 52, 627, "Input",
  InitializationCell->True],
Cell[9861, 228, 1000, 18, 270, "Input",
  InitializationCell->True],
Cell[10864, 248, 2923, 51, 606, "Input",
  InitializationCell->True],
Cell[13790, 301, 2840, 51, 606, "Input",
  InitializationCell->True],
Cell[16633, 354, 914, 17, 228, "Input",
  InitializationCell->True],
Cell[17550, 373, 1448, 25, 291, "Input",
  InitializationCell->True],
Cell[19001, 400, 3317, 61, 648, "Input",
  InitializationCell->True],
Cell[22321, 463, 4709, 86, 376, "Input",
  InitializationCell->True],
Cell[27033, 551, 2608, 50, 337, "Input",
  InitializationCell->True],
Cell[29644, 603, 799, 16, 223, "Input",
  InitializationCell->True],
Cell[30446, 621, 316, 6, 102, "Input",
  InitializationCell->True],
Cell[30765, 629, 1023, 17, 249, "Input",
  InitializationCell->True],
Cell[31791, 648, 4334, 87, 380, "Input",
  InitializationCell->True],
Cell[36128, 737, 86, 2, 60, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[36251, 744, 58, 0, 77, "Section"],
Cell[36312, 746, 3265, 102, 207, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[39614, 853, 57, 0, 77, "Section"],

Cell[CellGroupData[{
Cell[39696, 857, 111, 5, 60, "Subsubsection"],
Cell[39810, 864, 1038, 29, 75, "Text"],
Cell[40851, 895, 125, 2, 60, "Input"],
Cell[40979, 899, 174, 3, 81, "Input"],
Cell[41156, 904, 175, 3, 82, "Input"],
Cell[41334, 909, 241, 6, 33, "Text"],
Cell[41578, 917, 170, 4, 51, "Text"],
Cell[41751, 923, 1297, 31, 117, "Text"],
Cell[43051, 956, 113, 2, 60, "Input"],
Cell[43167, 960, 113, 2, 60, "Input"],
Cell[43283, 964, 183, 4, 33, "Text"],
Cell[43469, 970, 340, 6, 123, "Input"],
Cell[43812, 978, 335, 6, 123, "Input"],
Cell[44150, 986, 1089, 35, 75, "Text"],
Cell[45242, 1023, 1163, 30, 130, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[46442, 1058, 36, 0, 56, "Subsubsection"],
Cell[46481, 1060, 282, 9, 33, "Text"],
Cell[46766, 1071, 94, 2, 33, "Text"],
Cell[46863, 1075, 103, 2, 61, "Input"],
Cell[46969, 1079, 121, 3, 33, "Text"],
Cell[47093, 1084, 186, 3, 82, "Input"],
Cell[47282, 1089, 149, 3, 33, "Text"],
Cell[47434, 1094, 105, 2, 61, "Input"],
Cell[47542, 1098, 287, 6, 34, "Text"],
Cell[47832, 1106, 122, 2, 81, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[47991, 1113, 36, 0, 56, "Subsubsection"],
Cell[48030, 1115, 270, 9, 33, "Text"],
Cell[48303, 1126, 308, 11, 33, "Text"],
Cell[48614, 1139, 73, 1, 61, "Input"],
Cell[48690, 1142, 175, 3, 88, "Input"],
Cell[48868, 1147, 542, 16, 55, "Text"],
Cell[49413, 1165, 720, 14, 154, "Input"],
Cell[50136, 1181, 447, 12, 35, "Text"],
Cell[50586, 1195, 124, 2, 64, "Input"],
Cell[50713, 1199, 782, 26, 55, "Text"],
Cell[51498, 1227, 321, 6, 175, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[51856, 1238, 46, 0, 56, "Subsubsection"],
Cell[51905, 1240, 1052, 24, 96, "Text"],
Cell[52960, 1266, 116, 2, 60, "Input"],
Cell[53079, 1270, 110, 2, 61, "Input"],
Cell[53192, 1274, 353, 11, 34, "Text"],
Cell[53548, 1287, 170, 4, 51, "Text"],
Cell[53721, 1293, 1414, 34, 118, "Text"],
Cell[55138, 1329, 110, 2, 60, "Input"],
Cell[55251, 1333, 110, 2, 60, "Input"],
Cell[55364, 1337, 183, 4, 33, "Text"],
Cell[55550, 1343, 319, 5, 123, "Input"],
Cell[55872, 1350, 319, 5, 123, "Input"],
Cell[56194, 1357, 3753, 88, 418, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[59984, 1450, 36, 0, 56, "Subsubsection"],
Cell[60023, 1452, 993, 26, 108, "Text"],
Cell[61019, 1480, 102, 2, 61, "Input"],
Cell[61124, 1484, 250, 7, 34, "Text"],
Cell[61377, 1493, 72, 1, 61, "Input"],
Cell[61452, 1496, 202, 3, 33, "Text"],
Cell[61657, 1501, 102, 2, 61, "Input"],
Cell[61762, 1505, 336, 8, 54, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[62135, 1518, 32, 0, 64, "Subsection"],
Cell[62170, 1520, 3167, 127, 455, "Text"],
Cell[65340, 1649, 231, 7, 38, "Text"],
Cell[65574, 1658, 201, 3, 112, "Input"],
Cell[65778, 1663, 389, 13, 44, "Text"],
Cell[66170, 1678, 306, 5, 112, "Input"],
Cell[66479, 1685, 300, 10, 34, "Text"],
Cell[66782, 1697, 240, 4, 114, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[67071, 1707, 71, 0, 77, "Section"],
Cell[67145, 1709, 4761, 114, 403, "Text"],

Cell[CellGroupData[{
Cell[71931, 1827, 34, 0, 56, "Subsubsection"],
Cell[71968, 1829, 760, 24, 55, "Text"],
Cell[72731, 1855, 113, 2, 60, "Input"],
Cell[72847, 1859, 656, 20, 55, "Text"],
Cell[73506, 1881, 187, 3, 81, "Input"],
Cell[73696, 1886, 94, 2, 33, "Text"],
Cell[73793, 1890, 238, 4, 142, "Input"],
Cell[74034, 1896, 620, 17, 55, "Text"],
Cell[74657, 1915, 165, 2, 60, "Input"],
Cell[74825, 1919, 429, 12, 54, "Text"],
Cell[75257, 1933, 239, 4, 142, "Input"],
Cell[75499, 1939, 1979, 53, 53, "Text"],
Cell[77481, 1994, 227, 4, 102, "Input"],
Cell[77711, 2000, 448, 8, 75, "Text"],
Cell[78162, 2010, 115, 2, 33, "Text"],
Cell[78280, 2014, 202, 4, 81, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[78519, 2023, 224, 7, 60, "Subsubsection"],
Cell[78746, 2032, 1133, 33, 77, "Text"],
Cell[79882, 2067, 1662, 44, 64, "Text"],
Cell[81547, 2113, 548, 11, 75, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[82132, 2129, 34, 0, 56, "Subsubsection"],
Cell[82169, 2131, 1557, 50, 32, "Text"],
Cell[83729, 2183, 160, 2, 33, "Text"],
Cell[83892, 2187, 145, 2, 102, "Input"],
Cell[84040, 2191, 1250, 40, 56, "Text"],
Cell[85293, 2233, 190, 3, 33, "Text"],
Cell[85486, 2238, 249, 4, 144, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[85772, 2247, 34, 0, 64, "Subsection"],
Cell[85809, 2249, 1214, 38, 34, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[87072, 2293, 70, 0, 77, "Section"],
Cell[87145, 2295, 3532, 115, 164, "Text"],
Cell[90680, 2412, 190, 3, 87, "Input"],
Cell[90873, 2417, 1913, 49, 172, "Text"],
Cell[92789, 2468, 331, 5, 101, "Input"],
Cell[93123, 2475, 628, 14, 108, "Input"],
Cell[93754, 2491, 311, 5, 102, "Input"],
Cell[94068, 2498, 958, 23, 75, "Text"],
Cell[95029, 2523, 69, 2, 79, "Input",
  InitializationCell->True],
Cell[95101, 2527, 2043, 54, 136, "Text"],
Cell[97147, 2583, 220, 5, 51, "Text"],
Cell[97370, 2590, 132, 2, 33, "Text"],
Cell[97505, 2594, 906, 23, 51, "Text"],
Cell[98414, 2619, 287, 6, 54, "Text"],
Cell[98704, 2627, 182, 3, 60, "Input"],
Cell[98889, 2632, 345, 6, 54, "Text"],

Cell[CellGroupData[{
Cell[99259, 2642, 33, 0, 56, "Subsubsection"],
Cell[99295, 2644, 573, 19, 34, "Text"],
Cell[99871, 2665, 360, 10, 53, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[100268, 2680, 34, 0, 64, "Subsection"],
Cell[100305, 2682, 2975, 103, 193, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[103329, 2791, 47, 0, 77, "Section"],
Cell[103379, 2793, 1764, 50, 136, "Text"],
Cell[105146, 2845, 129, 2, 80, "Input"],
Cell[105278, 2849, 139, 2, 60, "Input"],
Cell[105420, 2853, 248, 4, 81, "Input"],
Cell[105671, 2859, 256, 4, 124, "Input"],
Cell[105930, 2865, 263, 5, 100, "Input"],
Cell[106196, 2872, 1440, 39, 130, "Text"],
Cell[107639, 2913, 356, 11, 59, "Text"],
Cell[107998, 2926, 764, 24, 68, "Text"],
Cell[108765, 2952, 362, 11, 59, "Text"],
Cell[109130, 2965, 539, 17, 54, "Text"],
Cell[109672, 2984, 239, 6, 51, "Text"],
Cell[109914, 2992, 584, 17, 68, "Text"],

Cell[CellGroupData[{
Cell[110523, 3013, 34, 0, 56, "Subsubsection"],
Cell[110560, 3015, 585, 26, 33, "Text"],
Cell[111148, 3043, 335, 6, 51, "Text"],
Cell[111486, 3051, 334, 11, 33, "Text"],
Cell[111823, 3064, 742, 16, 51, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[112602, 3085, 32, 0, 64, "Subsection"],
Cell[112637, 3087, 2995, 104, 196, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[115681, 3197, 148, 4, 77, "Section"],
Cell[115832, 3203, 1200, 29, 143, "Text"],
Cell[117035, 3234, 70, 2, 79, "Input",
  InitializationCell->True],
Cell[117108, 3238, 1362, 35, 96, "Text"],
Cell[118473, 3275, 335, 8, 32, "Text"],
Cell[118811, 3285, 39, 0, 33, "Text"],
Cell[118853, 3287, 448, 13, 50, "Text"],
Cell[119304, 3302, 313, 8, 33, "Text"],
Cell[119620, 3312, 202, 5, 51, "Text"],
Cell[119825, 3319, 1220, 33, 101, "Text"],
Cell[121048, 3354, 808, 16, 264, "Input"],
Cell[121859, 3372, 916, 21, 88, "Text"],

Cell[CellGroupData[{
Cell[122800, 3397, 64, 0, 64, "Subsection"],
Cell[122867, 3399, 756, 15, 96, "Text"],
Cell[123626, 3416, 612, 11, 205, "Input"],

Cell[CellGroupData[{
Cell[124263, 3431, 104, 2, 56, "Subsubsection"],
Cell[124370, 3435, 1524, 47, 96, "Text"],
Cell[125897, 3484, 174, 5, 51, "Text"],
Cell[126074, 3491, 521, 14, 54, "Text"],
Cell[126598, 3507, 294, 8, 51, "Text"],
Cell[126895, 3517, 196, 4, 33, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[127128, 3526, 34, 0, 56, "Subsubsection"],
Cell[127165, 3528, 1102, 34, 97, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[128316, 3568, 34, 0, 64, "Subsection"],
Cell[128353, 3570, 3457, 123, 212, "Text"],

Cell[CellGroupData[{
Cell[131835, 3697, 78, 0, 56, "Subsubsection"],
Cell[131916, 3699, 255, 8, 33, "Text"],
Cell[132174, 3709, 98, 2, 61, "Input"],
Cell[132275, 3713, 67, 0, 33, "Text"],
Cell[132345, 3715, 234, 4, 101, "Input"],
Cell[132582, 3721, 264, 4, 54, "Text"],
Cell[132849, 3727, 548, 9, 186, "Input"],
Cell[133400, 3738, 201, 4, 33, "Text"],
Cell[133604, 3744, 771, 12, 270, "Input"],
Cell[134378, 3758, 1322, 35, 109, "Text"],
Cell[135703, 3795, 383, 8, 61, "Text"],
Cell[136089, 3805, 535, 15, 54, "Text"],
Cell[136627, 3822, 171, 5, 51, "Text"],
Cell[136801, 3829, 392, 12, 54, "Text"],
Cell[137196, 3843, 179, 5, 51, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[137412, 3853, 34, 0, 56, "Subsubsection"],
Cell[137449, 3855, 996, 37, 55, "Text"],
Cell[138448, 3894, 608, 9, 183, "Input"],
Cell[139059, 3905, 322, 7, 55, "Text"],
Cell[139384, 3914, 379, 9, 51, "Text"],
Cell[139766, 3925, 586, 18, 34, "Text"],
Cell[140355, 3945, 67, 1, 64, "Input"],
Cell[140425, 3948, 717, 11, 199, "Input"],
Cell[141145, 3961, 735, 20, 59, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[141929, 3987, 34, 0, 64, "Subsection"],
Cell[141966, 3989, 898, 31, 68, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[142913, 4026, 78, 0, 77, "Section"],
Cell[142994, 4028, 482, 9, 54, "Text"],
Cell[143479, 4039, 70, 2, 79, "Input",
  InitializationCell->True],
Cell[143552, 4043, 878, 30, 77, "Text"],
Cell[144433, 4075, 525, 18, 33, "Text"],
Cell[144961, 4095, 26, 0, 33, "Text"],
Cell[144990, 4097, 613, 15, 50, "Text"],
Cell[145606, 4114, 385, 11, 34, "Text"],
Cell[145994, 4127, 213, 5, 51, "Text"],

Cell[CellGroupData[{
Cell[146232, 4136, 34, 0, 56, "Subsubsection"],
Cell[146269, 4138, 837, 24, 64, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[147143, 4167, 34, 0, 64, "Subsection"],
Cell[147180, 4169, 2884, 87, 304, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

